/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Operation;
import org.stellar.sdk.xdr.BumpSequenceOp;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.SequenceNumber;

public class BumpSequenceOperation
extends Operation {
    private final long bumpTo;

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        BumpSequenceOp op = new BumpSequenceOp();
        Int64 bumpTo = new Int64();
        bumpTo.setInt64(this.bumpTo);
        SequenceNumber sequenceNumber = new SequenceNumber();
        sequenceNumber.setSequenceNumber(bumpTo);
        op.setBumpTo(sequenceNumber);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.BUMP_SEQUENCE);
        body.setBumpSequenceOp(op);
        return body;
    }

    @Generated
    public long getBumpTo() {
        return this.bumpTo;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BumpSequenceOperation)) {
            return false;
        }
        BumpSequenceOperation other = (BumpSequenceOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.getBumpTo() == other.getBumpTo();
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BumpSequenceOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $bumpTo = this.getBumpTo();
        result = result * 59 + (int)($bumpTo >>> 32 ^ $bumpTo);
        return result;
    }

    @Generated
    private BumpSequenceOperation(long bumpTo) {
        this.bumpTo = bumpTo;
    }

    public static class Builder {
        private final long bumpTo;
        private String sourceAccount;

        Builder(BumpSequenceOp op) {
            this.bumpTo = op.getBumpTo().getSequenceNumber().getInt64();
        }

        public Builder(long bumpTo) {
            this.bumpTo = bumpTo;
        }

        public Builder setSourceAccount(@NonNull String sourceAccount) {
            if (sourceAccount == null) {
                throw new NullPointerException("sourceAccount is marked non-null but is null");
            }
            this.sourceAccount = sourceAccount;
            return this;
        }

        public BumpSequenceOperation build() {
            BumpSequenceOperation operation = new BumpSequenceOperation(this.bumpTo);
            if (this.sourceAccount != null) {
                operation.setSourceAccount(this.sourceAccount);
            }
            return operation;
        }
    }
}

