/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Operation;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.xdr.CreateAccountOp;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;

public class CreateAccountOperation
extends Operation {
    @NonNull
    private final String destination;
    @NonNull
    private final String startingBalance;

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        CreateAccountOp op = new CreateAccountOp();
        op.setDestination(StrKey.encodeToXDRAccountId(this.destination));
        Int64 startingBalance = new Int64();
        startingBalance.setInt64(Operation.toXdrAmount(this.startingBalance));
        op.setStartingBalance(startingBalance);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.CREATE_ACCOUNT);
        body.setCreateAccountOp(op);
        return body;
    }

    @NonNull
    @Generated
    public String getDestination() {
        return this.destination;
    }

    @NonNull
    @Generated
    public String getStartingBalance() {
        return this.startingBalance;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateAccountOperation)) {
            return false;
        }
        CreateAccountOperation other = (CreateAccountOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$destination = this.getDestination();
        String other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        String this$startingBalance = this.getStartingBalance();
        String other$startingBalance = other.getStartingBalance();
        return !(this$startingBalance == null ? other$startingBalance != null : !this$startingBalance.equals(other$startingBalance));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CreateAccountOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        String $startingBalance = this.getStartingBalance();
        result = result * 59 + ($startingBalance == null ? 43 : $startingBalance.hashCode());
        return result;
    }

    @Generated
    private CreateAccountOperation(@NonNull String destination, @NonNull String startingBalance) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (startingBalance == null) {
            throw new NullPointerException("startingBalance is marked non-null but is null");
        }
        this.destination = destination;
        this.startingBalance = startingBalance;
    }

    public static class Builder {
        private final String destination;
        private final String startingBalance;
        private String sourceAccount;

        Builder(CreateAccountOp op) {
            this.destination = StrKey.encodeEd25519PublicKey(op.getDestination());
            this.startingBalance = Operation.fromXdrAmount(op.getStartingBalance().getInt64());
        }

        public Builder(String destination, String startingBalance) {
            this.destination = destination;
            this.startingBalance = startingBalance;
        }

        public Builder setSourceAccount(String account) {
            this.sourceAccount = account;
            return this;
        }

        public CreateAccountOperation build() {
            CreateAccountOperation operation = new CreateAccountOperation(this.destination, this.startingBalance);
            if (this.sourceAccount != null) {
                operation.setSourceAccount(this.sourceAccount);
            }
            return operation;
        }
    }
}

