/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.AssetAmount;
import org.stellar.sdk.LiquidityPoolID;
import org.stellar.sdk.LiquidityPoolParameters;
import org.stellar.sdk.Operation;
import org.stellar.sdk.Price;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.LiquidityPoolDepositOp;
import org.stellar.sdk.xdr.LiquidityPoolType;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;

public class LiquidityPoolDepositOperation
extends Operation {
    @NonNull
    private final LiquidityPoolID liquidityPoolID;
    @NonNull
    private final String maxAmountA;
    @NonNull
    private final String maxAmountB;
    @NonNull
    private final Price minPrice;
    @NonNull
    private final Price maxPrice;

    public LiquidityPoolDepositOperation(LiquidityPoolDepositOp op) {
        this.liquidityPoolID = LiquidityPoolID.fromXdr(op.getLiquidityPoolID());
        this.maxAmountA = Operation.fromXdrAmount(op.getMaxAmountA().getInt64());
        this.maxAmountB = Operation.fromXdrAmount(op.getMaxAmountB().getInt64());
        this.minPrice = Price.fromXdr(op.getMinPrice());
        this.maxPrice = Price.fromXdr(op.getMaxPrice());
    }

    public LiquidityPoolDepositOperation(AssetAmount a, AssetAmount b, @NonNull Price minPrice, @NonNull Price maxPrice) {
        if (minPrice == null) {
            throw new NullPointerException("minPrice is marked non-null but is null");
        }
        if (maxPrice == null) {
            throw new NullPointerException("maxPrice is marked non-null but is null");
        }
        if (a.getAsset().compareTo(b.getAsset()) >= 0) {
            throw new RuntimeException("AssetA must be < AssetB");
        }
        this.liquidityPoolID = new LiquidityPoolID(LiquidityPoolType.LIQUIDITY_POOL_CONSTANT_PRODUCT, a.getAsset(), b.getAsset(), LiquidityPoolParameters.Fee);
        this.maxAmountA = a.getAmount();
        this.maxAmountB = b.getAmount();
        this.minPrice = minPrice;
        this.maxPrice = maxPrice;
    }

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        LiquidityPoolDepositOp op = new LiquidityPoolDepositOp();
        op.setLiquidityPoolID(this.getLiquidityPoolID().toXdr());
        op.setMaxAmountA(new Int64(Operation.toXdrAmount(this.getMaxAmountA())));
        op.setMaxAmountB(new Int64(Operation.toXdrAmount(this.getMaxAmountB())));
        op.setMinPrice(this.getMinPrice().toXdr());
        op.setMaxPrice(this.getMaxPrice().toXdr());
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.LIQUIDITY_POOL_DEPOSIT);
        body.setLiquidityPoolDepositOp(op);
        return body;
    }

    @NonNull
    @Generated
    public LiquidityPoolID getLiquidityPoolID() {
        return this.liquidityPoolID;
    }

    @NonNull
    @Generated
    public String getMaxAmountA() {
        return this.maxAmountA;
    }

    @NonNull
    @Generated
    public String getMaxAmountB() {
        return this.maxAmountB;
    }

    @NonNull
    @Generated
    public Price getMinPrice() {
        return this.minPrice;
    }

    @NonNull
    @Generated
    public Price getMaxPrice() {
        return this.maxPrice;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LiquidityPoolDepositOperation)) {
            return false;
        }
        LiquidityPoolDepositOperation other = (LiquidityPoolDepositOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LiquidityPoolID this$liquidityPoolID = this.getLiquidityPoolID();
        LiquidityPoolID other$liquidityPoolID = other.getLiquidityPoolID();
        if (this$liquidityPoolID == null ? other$liquidityPoolID != null : !((Object)this$liquidityPoolID).equals(other$liquidityPoolID)) {
            return false;
        }
        String this$maxAmountA = this.getMaxAmountA();
        String other$maxAmountA = other.getMaxAmountA();
        if (this$maxAmountA == null ? other$maxAmountA != null : !this$maxAmountA.equals(other$maxAmountA)) {
            return false;
        }
        String this$maxAmountB = this.getMaxAmountB();
        String other$maxAmountB = other.getMaxAmountB();
        if (this$maxAmountB == null ? other$maxAmountB != null : !this$maxAmountB.equals(other$maxAmountB)) {
            return false;
        }
        Price this$minPrice = this.getMinPrice();
        Price other$minPrice = other.getMinPrice();
        if (this$minPrice == null ? other$minPrice != null : !((Object)this$minPrice).equals(other$minPrice)) {
            return false;
        }
        Price this$maxPrice = this.getMaxPrice();
        Price other$maxPrice = other.getMaxPrice();
        return !(this$maxPrice == null ? other$maxPrice != null : !((Object)this$maxPrice).equals(other$maxPrice));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LiquidityPoolDepositOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        LiquidityPoolID $liquidityPoolID = this.getLiquidityPoolID();
        result = result * 59 + ($liquidityPoolID == null ? 43 : ((Object)$liquidityPoolID).hashCode());
        String $maxAmountA = this.getMaxAmountA();
        result = result * 59 + ($maxAmountA == null ? 43 : $maxAmountA.hashCode());
        String $maxAmountB = this.getMaxAmountB();
        result = result * 59 + ($maxAmountB == null ? 43 : $maxAmountB.hashCode());
        Price $minPrice = this.getMinPrice();
        result = result * 59 + ($minPrice == null ? 43 : ((Object)$minPrice).hashCode());
        Price $maxPrice = this.getMaxPrice();
        result = result * 59 + ($maxPrice == null ? 43 : ((Object)$maxPrice).hashCode());
        return result;
    }

    @Generated
    public LiquidityPoolDepositOperation(@NonNull LiquidityPoolID liquidityPoolID, @NonNull String maxAmountA, @NonNull String maxAmountB, @NonNull Price minPrice, @NonNull Price maxPrice) {
        if (liquidityPoolID == null) {
            throw new NullPointerException("liquidityPoolID is marked non-null but is null");
        }
        if (maxAmountA == null) {
            throw new NullPointerException("maxAmountA is marked non-null but is null");
        }
        if (maxAmountB == null) {
            throw new NullPointerException("maxAmountB is marked non-null but is null");
        }
        if (minPrice == null) {
            throw new NullPointerException("minPrice is marked non-null but is null");
        }
        if (maxPrice == null) {
            throw new NullPointerException("maxPrice is marked non-null but is null");
        }
        this.liquidityPoolID = liquidityPoolID;
        this.maxAmountA = maxAmountA;
        this.maxAmountB = maxAmountB;
        this.minPrice = minPrice;
        this.maxPrice = maxPrice;
    }
}

