/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.util.EnumSet;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeCreditAlphaNum;
import org.stellar.sdk.Operation;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.Util;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.SetTrustLineFlagsOp;
import org.stellar.sdk.xdr.TrustLineFlags;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrUnsignedInteger;

public class SetTrustlineFlagsOperation
extends Operation {
    @NonNull
    private final String trustor;
    @NonNull
    private final AssetTypeCreditAlphaNum asset;
    @NonNull
    private final EnumSet<TrustLineFlags> clearFlags;
    @NonNull
    private final EnumSet<TrustLineFlags> setFlags;

    public Asset getAsset() {
        return this.asset;
    }

    private static Uint32 bitwiseOr(EnumSet<TrustLineFlags> set) {
        int v = 0;
        for (TrustLineFlags f : set) {
            v |= f.getValue();
        }
        Uint32 combined = new Uint32();
        combined.setUint32(new XdrUnsignedInteger(v));
        return combined;
    }

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        SetTrustLineFlagsOp op = new SetTrustLineFlagsOp();
        op.setTrustor(StrKey.encodeToXDRAccountId(this.trustor));
        op.setAsset(this.asset.toXdr());
        op.setClearFlags(SetTrustlineFlagsOperation.bitwiseOr(this.clearFlags));
        op.setSetFlags(SetTrustlineFlagsOperation.bitwiseOr(this.setFlags));
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.SET_TRUST_LINE_FLAGS);
        body.setSetTrustLineFlagsOp(op);
        return body;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetTrustlineFlagsOperation)) {
            return false;
        }
        SetTrustlineFlagsOperation other = (SetTrustlineFlagsOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$trustor = this.getTrustor();
        String other$trustor = other.getTrustor();
        if (this$trustor == null ? other$trustor != null : !this$trustor.equals(other$trustor)) {
            return false;
        }
        Asset this$asset = this.getAsset();
        Asset other$asset = other.getAsset();
        if (this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset)) {
            return false;
        }
        EnumSet<TrustLineFlags> this$clearFlags = this.getClearFlags();
        EnumSet<TrustLineFlags> other$clearFlags = other.getClearFlags();
        if (this$clearFlags == null ? other$clearFlags != null : !((Object)this$clearFlags).equals(other$clearFlags)) {
            return false;
        }
        EnumSet<TrustLineFlags> this$setFlags = this.getSetFlags();
        EnumSet<TrustLineFlags> other$setFlags = other.getSetFlags();
        return !(this$setFlags == null ? other$setFlags != null : !((Object)this$setFlags).equals(other$setFlags));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SetTrustlineFlagsOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $trustor = this.getTrustor();
        result = result * 59 + ($trustor == null ? 43 : $trustor.hashCode());
        Asset $asset = this.getAsset();
        result = result * 59 + ($asset == null ? 43 : $asset.hashCode());
        EnumSet<TrustLineFlags> $clearFlags = this.getClearFlags();
        result = result * 59 + ($clearFlags == null ? 43 : ((Object)$clearFlags).hashCode());
        EnumSet<TrustLineFlags> $setFlags = this.getSetFlags();
        result = result * 59 + ($setFlags == null ? 43 : ((Object)$setFlags).hashCode());
        return result;
    }

    @Generated
    private SetTrustlineFlagsOperation(@NonNull String trustor, @NonNull AssetTypeCreditAlphaNum asset, @NonNull EnumSet<TrustLineFlags> clearFlags, @NonNull EnumSet<TrustLineFlags> setFlags) {
        if (trustor == null) {
            throw new NullPointerException("trustor is marked non-null but is null");
        }
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (clearFlags == null) {
            throw new NullPointerException("clearFlags is marked non-null but is null");
        }
        if (setFlags == null) {
            throw new NullPointerException("setFlags is marked non-null but is null");
        }
        this.trustor = trustor;
        this.asset = asset;
        this.clearFlags = clearFlags;
        this.setFlags = setFlags;
    }

    @NonNull
    @Generated
    public String getTrustor() {
        return this.trustor;
    }

    @NonNull
    @Generated
    public EnumSet<TrustLineFlags> getClearFlags() {
        return this.clearFlags;
    }

    @NonNull
    @Generated
    public EnumSet<TrustLineFlags> getSetFlags() {
        return this.setFlags;
    }

    public static class Builder {
        private final String trustor;
        private final AssetTypeCreditAlphaNum asset;
        private final EnumSet<TrustLineFlags> clearFlags;
        private final EnumSet<TrustLineFlags> setFlags;
        private String sourceAccount;

        Builder(SetTrustLineFlagsOp op) {
            this.trustor = StrKey.encodeEd25519PublicKey(op.getTrustor());
            this.asset = Util.assertNonNativeAsset(Asset.fromXdr(op.getAsset()));
            this.clearFlags = Builder.flagSetFromInt(op.getClearFlags().getUint32().getNumber().intValue());
            this.setFlags = Builder.flagSetFromInt(op.getSetFlags().getUint32().getNumber().intValue());
        }

        private static EnumSet<TrustLineFlags> flagSetFromInt(int x) {
            EnumSet<TrustLineFlags> set = EnumSet.noneOf(TrustLineFlags.class);
            for (TrustLineFlags flag : TrustLineFlags.values()) {
                if ((flag.getValue() & x) == 0) continue;
                set.add(flag);
            }
            return set;
        }

        public Builder(String trustor, Asset asset, EnumSet<TrustLineFlags> clearFlags, EnumSet<TrustLineFlags> setFlags) {
            this.trustor = trustor;
            this.asset = Util.assertNonNativeAsset(asset);
            this.clearFlags = clearFlags;
            this.setFlags = setFlags;
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.sourceAccount = sourceAccount;
            return this;
        }

        public SetTrustlineFlagsOperation build() {
            SetTrustlineFlagsOperation operation = new SetTrustlineFlagsOperation(this.trustor, this.asset, this.clearFlags, this.setFlags);
            if (this.sourceAccount != null) {
                operation.setSourceAccount(this.sourceAccount);
            }
            return operation;
        }
    }
}

