/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.Nullable;
import org.stellar.sdk.Account;
import org.stellar.sdk.AccountNotFoundException;
import org.stellar.sdk.Address;
import org.stellar.sdk.InvokeHostFunctionOperation;
import org.stellar.sdk.KeyPair;
import org.stellar.sdk.Operation;
import org.stellar.sdk.PrepareTransactionException;
import org.stellar.sdk.Transaction;
import org.stellar.sdk.TransactionBuilderAccount;
import org.stellar.sdk.requests.ClientIdentificationInterceptor;
import org.stellar.sdk.requests.ResponseHandler;
import org.stellar.sdk.requests.sorobanrpc.GetEventsRequest;
import org.stellar.sdk.requests.sorobanrpc.GetLedgerEntriesRequest;
import org.stellar.sdk.requests.sorobanrpc.GetTransactionRequest;
import org.stellar.sdk.requests.sorobanrpc.SendTransactionRequest;
import org.stellar.sdk.requests.sorobanrpc.SimulateTransactionRequest;
import org.stellar.sdk.requests.sorobanrpc.SorobanRpcErrorResponse;
import org.stellar.sdk.requests.sorobanrpc.SorobanRpcRequest;
import org.stellar.sdk.responses.sorobanrpc.GetEventsResponse;
import org.stellar.sdk.responses.sorobanrpc.GetHealthResponse;
import org.stellar.sdk.responses.sorobanrpc.GetLatestLedgerResponse;
import org.stellar.sdk.responses.sorobanrpc.GetLedgerEntriesResponse;
import org.stellar.sdk.responses.sorobanrpc.GetNetworkResponse;
import org.stellar.sdk.responses.sorobanrpc.GetTransactionResponse;
import org.stellar.sdk.responses.sorobanrpc.SendTransactionResponse;
import org.stellar.sdk.responses.sorobanrpc.SimulateTransactionResponse;
import org.stellar.sdk.responses.sorobanrpc.SorobanRpcResponse;
import org.stellar.sdk.xdr.ContractDataDurability;
import org.stellar.sdk.xdr.LedgerEntry;
import org.stellar.sdk.xdr.LedgerEntryType;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.SCVal;
import org.stellar.sdk.xdr.SorobanAuthorizationEntry;
import org.stellar.sdk.xdr.SorobanTransactionData;

public class SorobanServer
implements Closeable {
    private static final int SUBMIT_TRANSACTION_TIMEOUT = 60;
    private static final int CONNECT_TIMEOUT = 10;
    private final HttpUrl serverURI;
    private final OkHttpClient httpClient;
    private final Gson gson = new Gson();

    public SorobanServer(String serverURI) {
        this(serverURI, new OkHttpClient.Builder().addInterceptor(new ClientIdentificationInterceptor()).connectTimeout(10L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).retryOnConnectionFailure(true).build());
    }

    public SorobanServer(String serverURI, OkHttpClient httpClient) {
        this.serverURI = HttpUrl.parse(serverURI);
        this.httpClient = httpClient;
    }

    public TransactionBuilderAccount getAccount(String accountId) throws IOException, AccountNotFoundException, SorobanRpcErrorResponse {
        LedgerEntry.LedgerEntryData ledgerEntryData;
        LedgerKey.LedgerKeyAccount ledgerKeyAccount = new LedgerKey.LedgerKeyAccount.Builder().accountID(KeyPair.fromAccountId(accountId).getXdrAccountId()).build();
        LedgerKey ledgerKey = new LedgerKey.Builder().account(ledgerKeyAccount).discriminant(LedgerEntryType.ACCOUNT).build();
        GetLedgerEntriesResponse getLedgerEntriesResponse = this.getLedgerEntries(Collections.singleton(ledgerKey));
        List<GetLedgerEntriesResponse.LedgerEntryResult> entries = getLedgerEntriesResponse.getEntries();
        if (entries == null || entries.isEmpty()) {
            throw new AccountNotFoundException(accountId);
        }
        try {
            ledgerEntryData = LedgerEntry.LedgerEntryData.fromXdrBase64(entries.get(0).getXdr());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid ledgerEntryData: " + entries.get(0).getXdr(), e);
        }
        long sequence2 = ledgerEntryData.getAccount().getSeqNum().getSequenceNumber().getInt64();
        return new Account(accountId, sequence2);
    }

    public GetHealthResponse getHealth() throws IOException, SorobanRpcErrorResponse {
        return this.sendRequest("getHealth", null, new TypeToken<SorobanRpcResponse<GetHealthResponse>>(){});
    }

    public Optional<GetLedgerEntriesResponse.LedgerEntryResult> getContractData(String contractId, SCVal key, Durability durability) throws IOException, SorobanRpcErrorResponse {
        ContractDataDurability contractDataDurability;
        switch (durability.ordinal()) {
            case 0: {
                contractDataDurability = ContractDataDurability.TEMPORARY;
                break;
            }
            case 1: {
                contractDataDurability = ContractDataDurability.PERSISTENT;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid durability: " + (Object)((Object)durability));
            }
        }
        Address address = new Address(contractId);
        LedgerKey.LedgerKeyContractData ledgerKeyContractData = new LedgerKey.LedgerKeyContractData.Builder().contract(address.toSCAddress()).key(key).durability(contractDataDurability).build();
        LedgerKey ledgerKey = new LedgerKey.Builder().discriminant(LedgerEntryType.CONTRACT_DATA).contractData(ledgerKeyContractData).build();
        GetLedgerEntriesResponse getLedgerEntriesResponse = this.getLedgerEntries(Collections.singleton(ledgerKey));
        List<GetLedgerEntriesResponse.LedgerEntryResult> entries = getLedgerEntriesResponse.getEntries();
        if (entries == null || entries.isEmpty()) {
            return Optional.empty();
        }
        GetLedgerEntriesResponse.LedgerEntryResult result = entries.get(0);
        return Optional.of(result);
    }

    public GetLedgerEntriesResponse getLedgerEntries(Collection<LedgerKey> keys2) throws IOException, SorobanRpcErrorResponse {
        if (keys2.isEmpty()) {
            throw new IllegalArgumentException("At least one key must be provided.");
        }
        ArrayList<String> xdrKeys = new ArrayList<String>(keys2.size());
        for (LedgerKey key : keys2) {
            String xdrBase64;
            try {
                xdrBase64 = key.toXdrBase64();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid ledgerKey: " + key, e);
            }
            xdrKeys.add(xdrBase64);
        }
        GetLedgerEntriesRequest params = new GetLedgerEntriesRequest(xdrKeys);
        return this.sendRequest("getLedgerEntries", params, new TypeToken<SorobanRpcResponse<GetLedgerEntriesResponse>>(){});
    }

    public GetTransactionResponse getTransaction(String hash) throws IOException, SorobanRpcErrorResponse {
        GetTransactionRequest params = new GetTransactionRequest(hash);
        return this.sendRequest("getTransaction", params, new TypeToken<SorobanRpcResponse<GetTransactionResponse>>(){});
    }

    public GetEventsResponse getEvents(GetEventsRequest getEventsRequest) throws IOException, SorobanRpcErrorResponse {
        return this.sendRequest("getEvents", getEventsRequest, new TypeToken<SorobanRpcResponse<GetEventsResponse>>(){});
    }

    public GetNetworkResponse getNetwork() throws IOException, SorobanRpcErrorResponse {
        return this.sendRequest("getNetwork", null, new TypeToken<SorobanRpcResponse<GetNetworkResponse>>(){});
    }

    public GetLatestLedgerResponse getLatestLedger() throws IOException, SorobanRpcErrorResponse {
        return this.sendRequest("getLatestLedger", null, new TypeToken<SorobanRpcResponse<GetLatestLedgerResponse>>(){});
    }

    public SimulateTransactionResponse simulateTransaction(Transaction transaction, @Nullable SimulateTransactionRequest.ResourceConfig resourceConfig) throws IOException, SorobanRpcErrorResponse {
        SimulateTransactionRequest params = new SimulateTransactionRequest(transaction.toEnvelopeXdrBase64(), resourceConfig);
        return this.sendRequest("simulateTransaction", params, new TypeToken<SorobanRpcResponse<SimulateTransactionResponse>>(){});
    }

    public SimulateTransactionResponse simulateTransaction(Transaction transaction) throws IOException, SorobanRpcErrorResponse {
        return this.simulateTransaction(transaction, null);
    }

    public Transaction prepareTransaction(Transaction transaction) throws IOException, SorobanRpcErrorResponse, PrepareTransactionException {
        SimulateTransactionResponse simulateTransactionResponse = this.simulateTransaction(transaction);
        return this.prepareTransaction(transaction, simulateTransactionResponse);
    }

    public Transaction prepareTransaction(Transaction transaction, SimulateTransactionResponse simulateTransactionResponse) throws PrepareTransactionException {
        if (simulateTransactionResponse.getError() != null) {
            throw new PrepareTransactionException("simulation transaction failed, the response contains error information.", simulateTransactionResponse);
        }
        return this.assembleTransaction(transaction, simulateTransactionResponse);
    }

    public SendTransactionResponse sendTransaction(Transaction transaction) throws IOException, SorobanRpcErrorResponse {
        SendTransactionRequest params = new SendTransactionRequest(transaction.toEnvelopeXdrBase64());
        return this.sendRequest("sendTransaction", params, new TypeToken<SorobanRpcResponse<SendTransactionResponse>>(){});
    }

    private Transaction assembleTransaction(Transaction transaction, SimulateTransactionResponse simulateTransactionResponse) {
        SorobanTransactionData sorobanData;
        if (!transaction.isSorobanTransaction()) {
            throw new IllegalArgumentException("unsupported transaction: must contain exactly one InvokeHostFunctionOperation, BumpSequenceOperation, or RestoreFootprintOperation");
        }
        long classicFeeNum = transaction.getFee();
        long minResourceFeeNum = Optional.ofNullable(simulateTransactionResponse.getMinResourceFee()).orElse(0L);
        long fee = classicFeeNum + minResourceFeeNum;
        Operation operation = transaction.getOperations()[0];
        if (operation instanceof InvokeHostFunctionOperation) {
            if (simulateTransactionResponse.getResults() == null || simulateTransactionResponse.getResults().size() != 1) {
                throw new IllegalArgumentException("invalid simulateTransactionResponse: results must contain exactly one element if the operation is an InvokeHostFunctionOperation");
            }
            SimulateTransactionResponse.SimulateHostFunctionResult simulateHostFunctionResult = simulateTransactionResponse.getResults().get(0);
            List<SorobanAuthorizationEntry> existingEntries = ((InvokeHostFunctionOperation)operation).getAuth();
            if (existingEntries.isEmpty() && simulateHostFunctionResult.getAuth() != null && !simulateHostFunctionResult.getAuth().isEmpty()) {
                ArrayList<SorobanAuthorizationEntry> authorizationEntries = new ArrayList<SorobanAuthorizationEntry>(simulateHostFunctionResult.getAuth().size());
                for (String auth : simulateHostFunctionResult.getAuth()) {
                    try {
                        authorizationEntries.add(SorobanAuthorizationEntry.fromXdrBase64(auth));
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Invalid auth: " + auth, e);
                    }
                }
                operation = ((InvokeHostFunctionOperation.InvokeHostFunctionOperationBuilder)((InvokeHostFunctionOperation.InvokeHostFunctionOperationBuilder)((Operation.OperationBuilder)InvokeHostFunctionOperation.builder().hostFunction(((InvokeHostFunctionOperation)operation).getHostFunction())).sourceAccount(operation.getSourceAccount())).auth(authorizationEntries)).build();
            }
        }
        try {
            sorobanData = SorobanTransactionData.fromXdrBase64(simulateTransactionResponse.getTransactionData());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid transactionData: " + simulateTransactionResponse.getTransactionData(), e);
        }
        return new Transaction(transaction.getAccountConverter(), transaction.getSourceAccount(), fee, transaction.getSequenceNumber(), new Operation[]{operation}, transaction.getMemo(), transaction.getPreconditions(), sorobanData, transaction.getNetwork());
    }

    private <T, R> R sendRequest(String method, @Nullable T params, TypeToken<SorobanRpcResponse<R>> responseType) throws IOException, SorobanRpcErrorResponse {
        String requestId = SorobanServer.generateRequestId();
        ResponseHandler<SorobanRpcResponse<R>> responseHandler = new ResponseHandler<SorobanRpcResponse<R>>(responseType);
        SorobanRpcRequest<T> sorobanRpcRequest = new SorobanRpcRequest<T>(requestId, method, params);
        MediaType mediaType = MediaType.parse("application/json");
        RequestBody requestBody = RequestBody.create(this.gson.toJson(sorobanRpcRequest).getBytes(), mediaType);
        Request request = new Request.Builder().url(this.serverURI).post(requestBody).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            SorobanRpcResponse<R> sorobanRpcResponse = responseHandler.handleResponse(response);
            if (sorobanRpcResponse.getError() != null) {
                SorobanRpcResponse.Error error = sorobanRpcResponse.getError();
                throw new SorobanRpcErrorResponse(error.getCode(), error.getMessage(), error.getData());
            }
            R r = sorobanRpcResponse.getResult();
            return r;
        }
    }

    @Override
    public void close() throws IOException {
        this.httpClient.connectionPool().evictAll();
    }

    private static String generateRequestId() {
        return UUID.randomUUID().toString();
    }

    public static enum Durability {
        TEMPORARY,
        PERSISTENT;

    }
}

