/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AbstractTransaction;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.CreateClaimableBalanceOperation;
import org.stellar.sdk.ExtendFootprintTTLOperation;
import org.stellar.sdk.InvokeHostFunctionOperation;
import org.stellar.sdk.Memo;
import org.stellar.sdk.Network;
import org.stellar.sdk.RestoreFootprintOperation;
import org.stellar.sdk.SorobanDataBuilder;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.TimeBounds;
import org.stellar.sdk.TransactionBuilder;
import org.stellar.sdk.TransactionBuilderAccount;
import org.stellar.sdk.TransactionPreconditions;
import org.stellar.sdk.Util;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.ClaimableBalanceID;
import org.stellar.sdk.xdr.ClaimableBalanceIDType;
import org.stellar.sdk.xdr.DecoratedSignature;
import org.stellar.sdk.xdr.EnvelopeType;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.HashIDPreimage;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.SequenceNumber;
import org.stellar.sdk.xdr.SorobanTransactionData;
import org.stellar.sdk.xdr.Transaction;
import org.stellar.sdk.xdr.TransactionEnvelope;
import org.stellar.sdk.xdr.TransactionSignaturePayload;
import org.stellar.sdk.xdr.TransactionV0;
import org.stellar.sdk.xdr.TransactionV0Envelope;
import org.stellar.sdk.xdr.TransactionV1Envelope;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrUnsignedInteger;

public class Transaction
extends AbstractTransaction {
    private final long fee;
    @NonNull
    private final String sourceAccount;
    private final long sequenceNumber;
    @NonNull
    private final org.stellar.sdk.Operation[] operations;
    @NonNull
    private final Memo memo;
    private final TransactionPreconditions preconditions;
    private final SorobanTransactionData sorobanData;
    private EnvelopeType envelopeType = EnvelopeType.ENVELOPE_TYPE_TX;

    Transaction(AccountConverter accountConverter, @NonNull String sourceAccount, long fee, long sequenceNumber, @NonNull org.stellar.sdk.Operation[] operations, Memo memo, TransactionPreconditions preconditions, SorobanTransactionData sorobanData, Network network) {
        super(accountConverter, network);
        if (sourceAccount == null) {
            throw new NullPointerException("sourceAccount is marked non-null but is null");
        }
        if (operations == null) {
            throw new NullPointerException("operations is marked non-null but is null");
        }
        this.sourceAccount = sourceAccount;
        this.sequenceNumber = sequenceNumber;
        this.operations = operations;
        if (operations.length == 0) {
            throw new IllegalArgumentException("At least one operation required");
        }
        this.preconditions = preconditions;
        this.fee = fee;
        this.memo = memo != null ? memo : Memo.none();
        this.sorobanData = sorobanData != null ? new SorobanDataBuilder(sorobanData).build() : null;
    }

    void setEnvelopeType(EnvelopeType envelopeType) {
        this.envelopeType = envelopeType;
    }

    @Override
    public byte[] signatureBase() {
        TransactionSignaturePayload.TransactionSignaturePayloadTaggedTransaction taggedTransaction = new TransactionSignaturePayload.TransactionSignaturePayloadTaggedTransaction();
        taggedTransaction.setDiscriminant(EnvelopeType.ENVELOPE_TYPE_TX);
        taggedTransaction.setTx(this.toV1Xdr(this.accountConverter));
        return Transaction.getTransactionSignatureBase(taggedTransaction, this.network);
    }

    public TimeBounds getTimeBounds() {
        return this.preconditions.getTimeBounds();
    }

    public String getClaimableBalanceId(int index) throws IOException {
        if (index < 0 || index >= this.operations.length) {
            throw new IllegalArgumentException("index: " + index + " is outside the bounds of the operations within this transaction");
        }
        if (!(this.operations[index] instanceof CreateClaimableBalanceOperation)) {
            throw new IllegalArgumentException("operation at index " + index + " is not of type CreateClaimableBalanceOperation: " + this.operations[index].getClass());
        }
        Uint32 opIndex = new Uint32(new XdrUnsignedInteger(index));
        SequenceNumber sequenceNumber = new SequenceNumber(new Int64(this.getSequenceNumber()));
        AccountID sourceAccount = StrKey.muxedAccountToAccountId(AccountConverter.disableMuxed().encode(this.getSourceAccount()));
        HashIDPreimage.HashIDPreimageOperationID operationID = new HashIDPreimage.HashIDPreimageOperationID.Builder().opNum(opIndex).seqNum(sequenceNumber).sourceAccount(sourceAccount).build();
        HashIDPreimage hashIDPreimage = new HashIDPreimage.Builder().discriminant(EnvelopeType.ENVELOPE_TYPE_OP_ID).operationID(operationID).build();
        ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream();
        hashIDPreimage.encode(new XdrDataOutputStream(outputStream2));
        Hash operationIDHash = new Hash(Util.hash(outputStream2.toByteArray()));
        outputStream2.reset();
        ClaimableBalanceID result = new ClaimableBalanceID();
        result.setDiscriminant(ClaimableBalanceIDType.CLAIMABLE_BALANCE_ID_TYPE_V0);
        result.setV0(operationIDHash);
        result.encode(new XdrDataOutputStream(outputStream2));
        return Util.bytesToHex(outputStream2.toByteArray()).toLowerCase();
    }

    private TransactionV0 toXdr() {
        Uint32 fee = new Uint32();
        fee.setUint32(new XdrUnsignedInteger(this.fee));
        Int64 sequenceNumberUint = new Int64();
        sequenceNumberUint.setInt64(this.sequenceNumber);
        SequenceNumber sequenceNumber = new SequenceNumber();
        sequenceNumber.setSequenceNumber(sequenceNumberUint);
        Operation[] operations = new Operation[this.operations.length];
        for (int i = 0; i < this.operations.length; ++i) {
            operations[i] = this.operations[i].toXdr(AccountConverter.enableMuxed());
        }
        TransactionV0.TransactionV0Ext ext = new TransactionV0.TransactionV0Ext();
        ext.setDiscriminant(0);
        TransactionV0 transaction = new TransactionV0();
        transaction.setFee(fee);
        transaction.setSeqNum(sequenceNumber);
        transaction.setSourceAccountEd25519(StrKey.encodeToXDRAccountId(this.sourceAccount).getAccountID().getEd25519());
        transaction.setOperations(operations);
        transaction.setMemo(this.memo.toXdr());
        transaction.setTimeBounds(this.getTimeBounds() == null ? null : this.getTimeBounds().toXdr());
        transaction.setExt(ext);
        return transaction;
    }

    private org.stellar.sdk.xdr.Transaction toV1Xdr(AccountConverter accountConverter) {
        Uint32 fee = new Uint32();
        fee.setUint32(new XdrUnsignedInteger(this.fee));
        Int64 sequenceNumberUint = new Int64();
        sequenceNumberUint.setInt64(this.sequenceNumber);
        SequenceNumber sequenceNumber = new SequenceNumber();
        sequenceNumber.setSequenceNumber(sequenceNumberUint);
        Operation[] operations = new Operation[this.operations.length];
        for (int i = 0; i < this.operations.length; ++i) {
            operations[i] = this.operations[i].toXdr(accountConverter);
        }
        Transaction.TransactionExt ext = new Transaction.TransactionExt();
        if (this.sorobanData != null) {
            ext.setDiscriminant(1);
            ext.setSorobanData(this.sorobanData);
        } else {
            ext.setDiscriminant(0);
        }
        org.stellar.sdk.xdr.Transaction v1Tx = new org.stellar.sdk.xdr.Transaction();
        v1Tx.setFee(fee);
        v1Tx.setSeqNum(sequenceNumber);
        v1Tx.setSourceAccount(accountConverter.encode(this.sourceAccount));
        v1Tx.setOperations(operations);
        v1Tx.setMemo(this.memo.toXdr());
        v1Tx.setCond(this.preconditions.toXdr());
        v1Tx.setExt(ext);
        return v1Tx;
    }

    public static Transaction fromV0EnvelopeXdr(AccountConverter accountConverter, TransactionV0Envelope envelope, Network network) {
        long mFee = envelope.getTx().getFee().getUint32().getNumber();
        Long mSequenceNumber = envelope.getTx().getSeqNum().getSequenceNumber().getInt64();
        Memo mMemo = Memo.fromXdr(envelope.getTx().getMemo());
        TimeBounds mTimeBounds = TimeBounds.fromXdr(envelope.getTx().getTimeBounds());
        org.stellar.sdk.Operation[] mOperations = new org.stellar.sdk.Operation[envelope.getTx().getOperations().length];
        for (int i = 0; i < envelope.getTx().getOperations().length; ++i) {
            mOperations[i] = org.stellar.sdk.Operation.fromXdr(accountConverter, envelope.getTx().getOperations()[i]);
        }
        Transaction transaction = new Transaction(accountConverter, StrKey.encodeEd25519PublicKey(envelope.getTx().getSourceAccountEd25519().getUint256()), mFee, mSequenceNumber, mOperations, mMemo, TransactionPreconditions.builder().timeBounds(mTimeBounds).build(), null, network);
        transaction.setEnvelopeType(EnvelopeType.ENVELOPE_TYPE_TX_V0);
        transaction.signatures.addAll(Arrays.asList(envelope.getSignatures()));
        return transaction;
    }

    public static Transaction fromV0EnvelopeXdr(TransactionV0Envelope envelope, Network network) {
        return Transaction.fromV0EnvelopeXdr(AccountConverter.enableMuxed(), envelope, network);
    }

    public static Transaction fromV1EnvelopeXdr(AccountConverter accountConverter, TransactionV1Envelope envelope, Network network) {
        long mFee = envelope.getTx().getFee().getUint32().getNumber();
        Long mSequenceNumber = envelope.getTx().getSeqNum().getSequenceNumber().getInt64();
        Memo mMemo = Memo.fromXdr(envelope.getTx().getMemo());
        org.stellar.sdk.Operation[] mOperations = new org.stellar.sdk.Operation[envelope.getTx().getOperations().length];
        for (int i = 0; i < envelope.getTx().getOperations().length; ++i) {
            mOperations[i] = org.stellar.sdk.Operation.fromXdr(accountConverter, envelope.getTx().getOperations()[i]);
        }
        SorobanTransactionData sorobanData = envelope.getTx().getExt().getSorobanData();
        Transaction transaction = new Transaction(accountConverter, accountConverter.decode(envelope.getTx().getSourceAccount()), mFee, mSequenceNumber, mOperations, mMemo, TransactionPreconditions.fromXdr(envelope.getTx().getCond()), sorobanData, network);
        transaction.signatures.addAll(Arrays.asList(envelope.getSignatures()));
        return transaction;
    }

    public static Transaction fromV1EnvelopeXdr(TransactionV1Envelope envelope, Network network) {
        return Transaction.fromV1EnvelopeXdr(AccountConverter.enableMuxed(), envelope, network);
    }

    @Override
    public TransactionEnvelope toEnvelopeXdr() {
        TransactionEnvelope xdr = new TransactionEnvelope();
        DecoratedSignature[] signatures = new DecoratedSignature[this.signatures.size()];
        signatures = this.signatures.toArray(signatures);
        if (this.envelopeType == EnvelopeType.ENVELOPE_TYPE_TX) {
            TransactionV1Envelope v1Envelope = new TransactionV1Envelope();
            xdr.setDiscriminant(EnvelopeType.ENVELOPE_TYPE_TX);
            v1Envelope.setTx(this.toV1Xdr(this.accountConverter));
            v1Envelope.setSignatures(signatures);
            xdr.setV1(v1Envelope);
        } else if (this.envelopeType == EnvelopeType.ENVELOPE_TYPE_TX_V0) {
            TransactionV0Envelope v0Envelope = new TransactionV0Envelope();
            xdr.setDiscriminant(EnvelopeType.ENVELOPE_TYPE_TX_V0);
            v0Envelope.setTx(this.toXdr());
            v0Envelope.setSignatures(signatures);
            xdr.setV0(v0Envelope);
        } else {
            throw new RuntimeException("invalid envelope type: " + this.envelopeType);
        }
        return xdr;
    }

    public boolean isSorobanTransaction() {
        if (this.operations.length != 1) {
            return false;
        }
        org.stellar.sdk.Operation op = this.operations[0];
        return op instanceof InvokeHostFunctionOperation || op instanceof ExtendFootprintTTLOperation || op instanceof RestoreFootprintOperation;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Transaction that = (Transaction)object;
        return Arrays.equals(this.signatureBase(), that.signatureBase());
    }

    public int hashCode() {
        return Arrays.hashCode(this.signatureBase());
    }

    @Generated
    public long getFee() {
        return this.fee;
    }

    @NonNull
    @Generated
    public String getSourceAccount() {
        return this.sourceAccount;
    }

    @Generated
    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    @NonNull
    @Generated
    public org.stellar.sdk.Operation[] getOperations() {
        return this.operations;
    }

    @NonNull
    @Generated
    public Memo getMemo() {
        return this.memo;
    }

    @Generated
    public TransactionPreconditions getPreconditions() {
        return this.preconditions;
    }

    @Generated
    public SorobanTransactionData getSorobanData() {
        return this.sorobanData;
    }

    @Deprecated
    public static class Builder
    extends TransactionBuilder {
        public Builder(AccountConverter accountConverter, TransactionBuilderAccount sourceAccount, Network network) {
            super(accountConverter, sourceAccount, network);
        }

        public Builder(TransactionBuilderAccount sourceAccount, Network network) {
            super(sourceAccount, network);
        }
    }
}

