/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses;

import com.google.gson.annotations.SerializedName;
import lombok.Generated;
import org.stellar.sdk.Asset;
import org.stellar.sdk.responses.Link;
import org.stellar.sdk.responses.Pageable;
import org.stellar.sdk.responses.Response;

public final class AssetResponse
extends Response
implements Pageable {
    @SerializedName(value="asset_type")
    private final String assetType;
    @SerializedName(value="asset_code")
    private final String assetCode;
    @SerializedName(value="asset_issuer")
    private final String assetIssuer;
    @SerializedName(value="paging_token")
    private final String pagingToken;
    @SerializedName(value="contract_id")
    private final String contractID;
    @SerializedName(value="num_accounts")
    private final int numAccounts;
    @SerializedName(value="num_claimable_balances")
    private final int numClaimableBalances;
    @SerializedName(value="num_liquidity_pools")
    private final int numLiquidityPools;
    @SerializedName(value="num_contracts")
    private final int numContracts;
    @SerializedName(value="num_archived_contracts")
    private final int numArchivedContracts;
    @SerializedName(value="amount")
    private final String amount;
    @SerializedName(value="accounts")
    private final Accounts accounts;
    @SerializedName(value="claimable_balances_amount")
    private final String claimableBalancesAmount;
    @SerializedName(value="liquidity_pools_amount")
    private final String liquidityPoolsAmount;
    @SerializedName(value="contracts_amount")
    private final String contractsAmount;
    @SerializedName(value="archived_contracts_amount")
    private final String archivedContractsAmount;
    @SerializedName(value="balances")
    private final Balances balances;
    @SerializedName(value="flags")
    private final Flags flags;
    @SerializedName(value="_links")
    private final Links links;

    public Asset getAsset() {
        return Asset.create(this.assetType, this.assetCode, this.assetIssuer);
    }

    @Generated
    public AssetResponse(String assetType, String assetCode, String assetIssuer, String pagingToken, String contractID, int numAccounts, int numClaimableBalances, int numLiquidityPools, int numContracts, int numArchivedContracts, String amount, Accounts accounts, String claimableBalancesAmount, String liquidityPoolsAmount, String contractsAmount, String archivedContractsAmount, Balances balances, Flags flags, Links links) {
        this.assetType = assetType;
        this.assetCode = assetCode;
        this.assetIssuer = assetIssuer;
        this.pagingToken = pagingToken;
        this.contractID = contractID;
        this.numAccounts = numAccounts;
        this.numClaimableBalances = numClaimableBalances;
        this.numLiquidityPools = numLiquidityPools;
        this.numContracts = numContracts;
        this.numArchivedContracts = numArchivedContracts;
        this.amount = amount;
        this.accounts = accounts;
        this.claimableBalancesAmount = claimableBalancesAmount;
        this.liquidityPoolsAmount = liquidityPoolsAmount;
        this.contractsAmount = contractsAmount;
        this.archivedContractsAmount = archivedContractsAmount;
        this.balances = balances;
        this.flags = flags;
        this.links = links;
    }

    @Generated
    public String getAssetType() {
        return this.assetType;
    }

    @Generated
    public String getAssetCode() {
        return this.assetCode;
    }

    @Generated
    public String getAssetIssuer() {
        return this.assetIssuer;
    }

    @Override
    @Generated
    public String getPagingToken() {
        return this.pagingToken;
    }

    @Generated
    public String getContractID() {
        return this.contractID;
    }

    @Generated
    public int getNumAccounts() {
        return this.numAccounts;
    }

    @Generated
    public int getNumClaimableBalances() {
        return this.numClaimableBalances;
    }

    @Generated
    public int getNumLiquidityPools() {
        return this.numLiquidityPools;
    }

    @Generated
    public int getNumContracts() {
        return this.numContracts;
    }

    @Generated
    public int getNumArchivedContracts() {
        return this.numArchivedContracts;
    }

    @Generated
    public String getAmount() {
        return this.amount;
    }

    @Generated
    public Accounts getAccounts() {
        return this.accounts;
    }

    @Generated
    public String getClaimableBalancesAmount() {
        return this.claimableBalancesAmount;
    }

    @Generated
    public String getLiquidityPoolsAmount() {
        return this.liquidityPoolsAmount;
    }

    @Generated
    public String getContractsAmount() {
        return this.contractsAmount;
    }

    @Generated
    public String getArchivedContractsAmount() {
        return this.archivedContractsAmount;
    }

    @Generated
    public Balances getBalances() {
        return this.balances;
    }

    @Generated
    public Flags getFlags() {
        return this.flags;
    }

    @Generated
    public Links getLinks() {
        return this.links;
    }

    @Generated
    public String toString() {
        return "AssetResponse(assetType=" + this.getAssetType() + ", assetCode=" + this.getAssetCode() + ", assetIssuer=" + this.getAssetIssuer() + ", pagingToken=" + this.getPagingToken() + ", contractID=" + this.getContractID() + ", numAccounts=" + this.getNumAccounts() + ", numClaimableBalances=" + this.getNumClaimableBalances() + ", numLiquidityPools=" + this.getNumLiquidityPools() + ", numContracts=" + this.getNumContracts() + ", numArchivedContracts=" + this.getNumArchivedContracts() + ", amount=" + this.getAmount() + ", accounts=" + this.getAccounts() + ", claimableBalancesAmount=" + this.getClaimableBalancesAmount() + ", liquidityPoolsAmount=" + this.getLiquidityPoolsAmount() + ", contractsAmount=" + this.getContractsAmount() + ", archivedContractsAmount=" + this.getArchivedContractsAmount() + ", balances=" + this.getBalances() + ", flags=" + this.getFlags() + ", links=" + this.getLinks() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssetResponse)) {
            return false;
        }
        AssetResponse other = (AssetResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNumAccounts() != other.getNumAccounts()) {
            return false;
        }
        if (this.getNumClaimableBalances() != other.getNumClaimableBalances()) {
            return false;
        }
        if (this.getNumLiquidityPools() != other.getNumLiquidityPools()) {
            return false;
        }
        if (this.getNumContracts() != other.getNumContracts()) {
            return false;
        }
        if (this.getNumArchivedContracts() != other.getNumArchivedContracts()) {
            return false;
        }
        String this$assetType = this.getAssetType();
        String other$assetType = other.getAssetType();
        if (this$assetType == null ? other$assetType != null : !this$assetType.equals(other$assetType)) {
            return false;
        }
        String this$assetCode = this.getAssetCode();
        String other$assetCode = other.getAssetCode();
        if (this$assetCode == null ? other$assetCode != null : !this$assetCode.equals(other$assetCode)) {
            return false;
        }
        String this$assetIssuer = this.getAssetIssuer();
        String other$assetIssuer = other.getAssetIssuer();
        if (this$assetIssuer == null ? other$assetIssuer != null : !this$assetIssuer.equals(other$assetIssuer)) {
            return false;
        }
        String this$pagingToken = this.getPagingToken();
        String other$pagingToken = other.getPagingToken();
        if (this$pagingToken == null ? other$pagingToken != null : !this$pagingToken.equals(other$pagingToken)) {
            return false;
        }
        String this$contractID = this.getContractID();
        String other$contractID = other.getContractID();
        if (this$contractID == null ? other$contractID != null : !this$contractID.equals(other$contractID)) {
            return false;
        }
        String this$amount = this.getAmount();
        String other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) {
            return false;
        }
        Accounts this$accounts = this.getAccounts();
        Accounts other$accounts = other.getAccounts();
        if (this$accounts == null ? other$accounts != null : !((Object)this$accounts).equals(other$accounts)) {
            return false;
        }
        String this$claimableBalancesAmount = this.getClaimableBalancesAmount();
        String other$claimableBalancesAmount = other.getClaimableBalancesAmount();
        if (this$claimableBalancesAmount == null ? other$claimableBalancesAmount != null : !this$claimableBalancesAmount.equals(other$claimableBalancesAmount)) {
            return false;
        }
        String this$liquidityPoolsAmount = this.getLiquidityPoolsAmount();
        String other$liquidityPoolsAmount = other.getLiquidityPoolsAmount();
        if (this$liquidityPoolsAmount == null ? other$liquidityPoolsAmount != null : !this$liquidityPoolsAmount.equals(other$liquidityPoolsAmount)) {
            return false;
        }
        String this$contractsAmount = this.getContractsAmount();
        String other$contractsAmount = other.getContractsAmount();
        if (this$contractsAmount == null ? other$contractsAmount != null : !this$contractsAmount.equals(other$contractsAmount)) {
            return false;
        }
        String this$archivedContractsAmount = this.getArchivedContractsAmount();
        String other$archivedContractsAmount = other.getArchivedContractsAmount();
        if (this$archivedContractsAmount == null ? other$archivedContractsAmount != null : !this$archivedContractsAmount.equals(other$archivedContractsAmount)) {
            return false;
        }
        Balances this$balances = this.getBalances();
        Balances other$balances = other.getBalances();
        if (this$balances == null ? other$balances != null : !((Object)this$balances).equals(other$balances)) {
            return false;
        }
        Flags this$flags = this.getFlags();
        Flags other$flags = other.getFlags();
        if (this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags)) {
            return false;
        }
        Links this$links = this.getLinks();
        Links other$links = other.getLinks();
        return !(this$links == null ? other$links != null : !((Object)this$links).equals(other$links));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AssetResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNumAccounts();
        result = result * 59 + this.getNumClaimableBalances();
        result = result * 59 + this.getNumLiquidityPools();
        result = result * 59 + this.getNumContracts();
        result = result * 59 + this.getNumArchivedContracts();
        String $assetType = this.getAssetType();
        result = result * 59 + ($assetType == null ? 43 : $assetType.hashCode());
        String $assetCode = this.getAssetCode();
        result = result * 59 + ($assetCode == null ? 43 : $assetCode.hashCode());
        String $assetIssuer = this.getAssetIssuer();
        result = result * 59 + ($assetIssuer == null ? 43 : $assetIssuer.hashCode());
        String $pagingToken = this.getPagingToken();
        result = result * 59 + ($pagingToken == null ? 43 : $pagingToken.hashCode());
        String $contractID = this.getContractID();
        result = result * 59 + ($contractID == null ? 43 : $contractID.hashCode());
        String $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : $amount.hashCode());
        Accounts $accounts = this.getAccounts();
        result = result * 59 + ($accounts == null ? 43 : ((Object)$accounts).hashCode());
        String $claimableBalancesAmount = this.getClaimableBalancesAmount();
        result = result * 59 + ($claimableBalancesAmount == null ? 43 : $claimableBalancesAmount.hashCode());
        String $liquidityPoolsAmount = this.getLiquidityPoolsAmount();
        result = result * 59 + ($liquidityPoolsAmount == null ? 43 : $liquidityPoolsAmount.hashCode());
        String $contractsAmount = this.getContractsAmount();
        result = result * 59 + ($contractsAmount == null ? 43 : $contractsAmount.hashCode());
        String $archivedContractsAmount = this.getArchivedContractsAmount();
        result = result * 59 + ($archivedContractsAmount == null ? 43 : $archivedContractsAmount.hashCode());
        Balances $balances = this.getBalances();
        result = result * 59 + ($balances == null ? 43 : ((Object)$balances).hashCode());
        Flags $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        Links $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        return result;
    }

    public static class Accounts {
        @SerializedName(value="authorized")
        int authorized;
        @SerializedName(value="authorized_to_maintain_liabilities")
        int authorizedToMaintainLiabilities;
        @SerializedName(value="unauthorized")
        int unauthorized;

        public int authorized() {
            return this.authorized;
        }

        public int authorizedToMaintainLiabilities() {
            return this.authorizedToMaintainLiabilities;
        }

        public int unauthorized() {
            return this.unauthorized;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accounts)) {
                return false;
            }
            Accounts other = (Accounts)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.authorized != other.authorized) {
                return false;
            }
            if (this.authorizedToMaintainLiabilities != other.authorizedToMaintainLiabilities) {
                return false;
            }
            return this.unauthorized == other.unauthorized;
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Accounts;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.authorized;
            result = result * 59 + this.authorizedToMaintainLiabilities;
            result = result * 59 + this.unauthorized;
            return result;
        }

        @Generated
        public Accounts(int authorized, int authorizedToMaintainLiabilities, int unauthorized) {
            this.authorized = authorized;
            this.authorizedToMaintainLiabilities = authorizedToMaintainLiabilities;
            this.unauthorized = unauthorized;
        }
    }

    public static class Balances {
        @SerializedName(value="authorized")
        String authorized;
        @SerializedName(value="authorized_to_maintain_liabilities")
        String authorizedToMaintainLiabilities;
        @SerializedName(value="unauthorized")
        String unauthorized;

        public String authorized() {
            return this.authorized;
        }

        public String authorizedToMaintainLiabilities() {
            return this.authorizedToMaintainLiabilities;
        }

        public String unauthorized() {
            return this.unauthorized;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Balances)) {
                return false;
            }
            Balances other = (Balances)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$authorized = this.authorized;
            String other$authorized = other.authorized;
            if (this$authorized == null ? other$authorized != null : !this$authorized.equals(other$authorized)) {
                return false;
            }
            String this$authorizedToMaintainLiabilities = this.authorizedToMaintainLiabilities;
            String other$authorizedToMaintainLiabilities = other.authorizedToMaintainLiabilities;
            if (this$authorizedToMaintainLiabilities == null ? other$authorizedToMaintainLiabilities != null : !this$authorizedToMaintainLiabilities.equals(other$authorizedToMaintainLiabilities)) {
                return false;
            }
            String this$unauthorized = this.unauthorized;
            String other$unauthorized = other.unauthorized;
            return !(this$unauthorized == null ? other$unauthorized != null : !this$unauthorized.equals(other$unauthorized));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Balances;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $authorized = this.authorized;
            result = result * 59 + ($authorized == null ? 43 : $authorized.hashCode());
            String $authorizedToMaintainLiabilities = this.authorizedToMaintainLiabilities;
            result = result * 59 + ($authorizedToMaintainLiabilities == null ? 43 : $authorizedToMaintainLiabilities.hashCode());
            String $unauthorized = this.unauthorized;
            result = result * 59 + ($unauthorized == null ? 43 : $unauthorized.hashCode());
            return result;
        }

        @Generated
        public Balances(String authorized, String authorizedToMaintainLiabilities, String unauthorized) {
            this.authorized = authorized;
            this.authorizedToMaintainLiabilities = authorizedToMaintainLiabilities;
            this.unauthorized = unauthorized;
        }
    }

    public static final class Flags {
        @SerializedName(value="auth_required")
        private final boolean authRequired;
        @SerializedName(value="auth_revocable")
        private final boolean authRevocable;
        @SerializedName(value="auth_immutable")
        private final boolean authImmutable;
        @SerializedName(value="auth_clawback_enabled")
        private final boolean authClawbackEnabled;

        @Generated
        public Flags(boolean authRequired, boolean authRevocable, boolean authImmutable, boolean authClawbackEnabled) {
            this.authRequired = authRequired;
            this.authRevocable = authRevocable;
            this.authImmutable = authImmutable;
            this.authClawbackEnabled = authClawbackEnabled;
        }

        @Generated
        public boolean isAuthRequired() {
            return this.authRequired;
        }

        @Generated
        public boolean isAuthRevocable() {
            return this.authRevocable;
        }

        @Generated
        public boolean isAuthImmutable() {
            return this.authImmutable;
        }

        @Generated
        public boolean isAuthClawbackEnabled() {
            return this.authClawbackEnabled;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Flags)) {
                return false;
            }
            Flags other = (Flags)o;
            if (this.isAuthRequired() != other.isAuthRequired()) {
                return false;
            }
            if (this.isAuthRevocable() != other.isAuthRevocable()) {
                return false;
            }
            if (this.isAuthImmutable() != other.isAuthImmutable()) {
                return false;
            }
            return this.isAuthClawbackEnabled() == other.isAuthClawbackEnabled();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAuthRequired() ? 79 : 97);
            result = result * 59 + (this.isAuthRevocable() ? 79 : 97);
            result = result * 59 + (this.isAuthImmutable() ? 79 : 97);
            result = result * 59 + (this.isAuthClawbackEnabled() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "AssetResponse.Flags(authRequired=" + this.isAuthRequired() + ", authRevocable=" + this.isAuthRevocable() + ", authImmutable=" + this.isAuthImmutable() + ", authClawbackEnabled=" + this.isAuthClawbackEnabled() + ")";
        }
    }

    public static final class Links {
        @SerializedName(value="toml")
        private final Link toml;

        @Generated
        public Links(Link toml) {
            this.toml = toml;
        }

        @Generated
        public Link getToml() {
            return this.toml;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Links)) {
                return false;
            }
            Links other = (Links)o;
            Link this$toml = this.getToml();
            Link other$toml = other.getToml();
            return !(this$toml == null ? other$toml != null : !((Object)this$toml).equals(other$toml));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Link $toml = this.getToml();
            result = result * 59 + ($toml == null ? 43 : ((Object)$toml).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AssetResponse.Links(toml=" + this.getToml() + ")";
        }
    }
}

