/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.ArrayList;
import org.stellar.sdk.Predicate;
import org.stellar.sdk.xdr.Duration;
import org.stellar.sdk.xdr.TimePoint;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrUnsignedHyperInteger;

public class PredicateDeserializer
implements JsonDeserializer<Predicate> {
    @Override
    public Predicate deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = json.getAsJsonObject();
        if (obj.has("unconditional")) {
            return new Predicate.Unconditional();
        }
        if (obj.has("not")) {
            return new Predicate.Not(this.deserialize(obj.get("not"), typeOfT, context));
        }
        if (obj.has("and")) {
            ArrayList<Predicate> inner = new ArrayList<Predicate>();
            for (JsonElement elt : obj.get("and").getAsJsonArray()) {
                inner.add(this.deserialize(elt, typeOfT, context));
            }
            return new Predicate.And(inner);
        }
        if (obj.has("or")) {
            ArrayList<Predicate> inner = new ArrayList<Predicate>();
            for (JsonElement elt : obj.get("or").getAsJsonArray()) {
                inner.add(this.deserialize(elt, typeOfT, context));
            }
            return new Predicate.Or(inner);
        }
        if (obj.has("abs_before_epoch")) {
            return new Predicate.AbsBefore(new TimePoint(new Uint64(new XdrUnsignedHyperInteger(obj.get("abs_before_epoch").getAsBigInteger()))));
        }
        if (obj.has("abs_before")) {
            String formattedDate = obj.get("abs_before").getAsString();
            return new Predicate.AbsBefore(new TimePoint(new Uint64(new XdrUnsignedHyperInteger(Instant.parse(formattedDate).getEpochSecond()))));
        }
        if (obj.has("rel_before")) {
            return new Predicate.RelBefore(new Duration(new Uint64(new XdrUnsignedHyperInteger(obj.get("rel_before").getAsBigInteger()))));
        }
        throw new IllegalArgumentException("Unsupported predicate: " + json.toString());
    }
}

