/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses;

import com.google.gson.annotations.SerializedName;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.responses.Response;
import org.stellar.sdk.xdr.OperationResult;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.TransactionResult;
import org.stellar.sdk.xdr.XdrDataInputStream;

public class SubmitTransactionResponse
extends Response {
    @SerializedName(value="hash")
    private final String hash;
    @SerializedName(value="ledger")
    private final Long ledger;
    @SerializedName(value="envelope_xdr")
    private final String envelopeXdr;
    @SerializedName(value="result_xdr")
    private final String resultXdr;
    @SerializedName(value="extras")
    private final Extras extras;
    TransactionResult transactionResult;

    SubmitTransactionResponse(Extras extras, Long ledger, String hash, String envelopeXdr, String resultXdr) {
        this.extras = extras;
        this.ledger = ledger;
        this.hash = hash;
        this.envelopeXdr = envelopeXdr;
        this.resultXdr = resultXdr;
    }

    public boolean isSuccess() {
        return this.ledger != null;
    }

    public Optional<String> getEnvelopeXdr() {
        if (this.isSuccess()) {
            return Optional.of(this.envelopeXdr);
        }
        if (this.getExtras() != null) {
            return Optional.of(this.getExtras().getEnvelopeXdr());
        }
        return Optional.empty();
    }

    public Optional<String> getResultXdr() {
        if (this.isSuccess()) {
            return Optional.of(this.resultXdr);
        }
        if (this.getExtras() != null) {
            return Optional.of(this.getExtras().getResultXdr());
        }
        return Optional.empty();
    }

    public Optional<Long> getOfferIdFromResult(int position) throws IOException {
        if (!this.isSuccess()) {
            return Optional.empty();
        }
        Optional<TransactionResult> optionalResult = this.getDecodedTransactionResult();
        if (!optionalResult.isPresent()) {
            return Optional.empty();
        }
        TransactionResult result = optionalResult.get();
        if (result.getResult().getResults()[position] == null) {
            return Optional.empty();
        }
        OperationResult operationResult = result.getResult().getResults()[position];
        OperationType operationType = operationResult.getTr().getDiscriminant();
        OperationResult.OperationResultTr operationResultTr = operationResult.getTr();
        if (operationType == OperationType.MANAGE_SELL_OFFER) {
            if (operationResultTr.getManageSellOfferResult().getSuccess().getOffer().getOffer() == null) {
                return Optional.empty();
            }
            return Optional.of(operationResultTr.getManageSellOfferResult().getSuccess().getOffer().getOffer().getOfferID().getInt64());
        }
        if (operationType == OperationType.MANAGE_BUY_OFFER) {
            if (operationResultTr.getManageBuyOfferResult().getSuccess().getOffer().getOffer() == null) {
                return Optional.empty();
            }
            return Optional.of(operationResultTr.getManageBuyOfferResult().getSuccess().getOffer().getOffer().getOfferID().getInt64());
        }
        return Optional.empty();
    }

    public Optional<TransactionResult> getDecodedTransactionResult() throws IOException {
        if (!this.isSuccess()) {
            return Optional.empty();
        }
        if (this.transactionResult == null) {
            Optional<String> resultXDR = this.getResultXdr();
            if (!resultXDR.isPresent()) {
                return Optional.empty();
            }
            byte[] bytes = Base64Factory.getInstance().decode(resultXDR.get());
            ByteArrayInputStream inputStream2 = new ByteArrayInputStream(bytes);
            XdrDataInputStream xdrInputStream = new XdrDataInputStream(inputStream2);
            this.transactionResult = TransactionResult.decode(xdrInputStream);
        }
        return Optional.of(this.transactionResult);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubmitTransactionResponse)) {
            return false;
        }
        SubmitTransactionResponse other = (SubmitTransactionResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$ledger = this.getLedger();
        Long other$ledger = other.getLedger();
        if (this$ledger == null ? other$ledger != null : !((Object)this$ledger).equals(other$ledger)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        Optional<String> this$envelopeXdr = this.getEnvelopeXdr();
        Optional<String> other$envelopeXdr = other.getEnvelopeXdr();
        if (this$envelopeXdr == null ? other$envelopeXdr != null : !((Object)this$envelopeXdr).equals(other$envelopeXdr)) {
            return false;
        }
        Optional<String> this$resultXdr = this.getResultXdr();
        Optional<String> other$resultXdr = other.getResultXdr();
        if (this$resultXdr == null ? other$resultXdr != null : !((Object)this$resultXdr).equals(other$resultXdr)) {
            return false;
        }
        Extras this$extras = this.getExtras();
        Extras other$extras = other.getExtras();
        if (this$extras == null ? other$extras != null : !((Object)this$extras).equals(other$extras)) {
            return false;
        }
        TransactionResult this$transactionResult = this.transactionResult;
        TransactionResult other$transactionResult = other.transactionResult;
        return !(this$transactionResult == null ? other$transactionResult != null : !((Object)this$transactionResult).equals(other$transactionResult));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SubmitTransactionResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $ledger = this.getLedger();
        result = result * 59 + ($ledger == null ? 43 : ((Object)$ledger).hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        Optional<String> $envelopeXdr = this.getEnvelopeXdr();
        result = result * 59 + ($envelopeXdr == null ? 43 : ((Object)$envelopeXdr).hashCode());
        Optional<String> $resultXdr = this.getResultXdr();
        result = result * 59 + ($resultXdr == null ? 43 : ((Object)$resultXdr).hashCode());
        Extras $extras = this.getExtras();
        result = result * 59 + ($extras == null ? 43 : ((Object)$extras).hashCode());
        TransactionResult $transactionResult = this.transactionResult;
        result = result * 59 + ($transactionResult == null ? 43 : ((Object)$transactionResult).hashCode());
        return result;
    }

    @Generated
    public String getHash() {
        return this.hash;
    }

    @Generated
    public Long getLedger() {
        return this.ledger;
    }

    @Generated
    public Extras getExtras() {
        return this.extras;
    }

    public static final class Extras {
        @SerializedName(value="envelope_xdr")
        private final String envelopeXdr;
        @SerializedName(value="result_xdr")
        private final String resultXdr;
        @SerializedName(value="result_codes")
        private final ResultCodes resultCodes;

        @Generated
        public Extras(String envelopeXdr, String resultXdr, ResultCodes resultCodes) {
            this.envelopeXdr = envelopeXdr;
            this.resultXdr = resultXdr;
            this.resultCodes = resultCodes;
        }

        @Generated
        public String getEnvelopeXdr() {
            return this.envelopeXdr;
        }

        @Generated
        public String getResultXdr() {
            return this.resultXdr;
        }

        @Generated
        public ResultCodes getResultCodes() {
            return this.resultCodes;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Extras)) {
                return false;
            }
            Extras other = (Extras)o;
            String this$envelopeXdr = this.getEnvelopeXdr();
            String other$envelopeXdr = other.getEnvelopeXdr();
            if (this$envelopeXdr == null ? other$envelopeXdr != null : !this$envelopeXdr.equals(other$envelopeXdr)) {
                return false;
            }
            String this$resultXdr = this.getResultXdr();
            String other$resultXdr = other.getResultXdr();
            if (this$resultXdr == null ? other$resultXdr != null : !this$resultXdr.equals(other$resultXdr)) {
                return false;
            }
            ResultCodes this$resultCodes = this.getResultCodes();
            ResultCodes other$resultCodes = other.getResultCodes();
            return !(this$resultCodes == null ? other$resultCodes != null : !((Object)this$resultCodes).equals(other$resultCodes));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $envelopeXdr = this.getEnvelopeXdr();
            result = result * 59 + ($envelopeXdr == null ? 43 : $envelopeXdr.hashCode());
            String $resultXdr = this.getResultXdr();
            result = result * 59 + ($resultXdr == null ? 43 : $resultXdr.hashCode());
            ResultCodes $resultCodes = this.getResultCodes();
            result = result * 59 + ($resultCodes == null ? 43 : ((Object)$resultCodes).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SubmitTransactionResponse.Extras(envelopeXdr=" + this.getEnvelopeXdr() + ", resultXdr=" + this.getResultXdr() + ", resultCodes=" + this.getResultCodes() + ")";
        }

        public static final class ResultCodes {
            @SerializedName(value="transaction")
            private final String transactionResultCode;
            @SerializedName(value="inner_transaction")
            private final String innerTransactionResultCode;
            @SerializedName(value="operations")
            private final ArrayList<String> operationsResultCodes;

            @Generated
            public ResultCodes(String transactionResultCode, String innerTransactionResultCode, ArrayList<String> operationsResultCodes) {
                this.transactionResultCode = transactionResultCode;
                this.innerTransactionResultCode = innerTransactionResultCode;
                this.operationsResultCodes = operationsResultCodes;
            }

            @Generated
            public String getTransactionResultCode() {
                return this.transactionResultCode;
            }

            @Generated
            public String getInnerTransactionResultCode() {
                return this.innerTransactionResultCode;
            }

            @Generated
            public ArrayList<String> getOperationsResultCodes() {
                return this.operationsResultCodes;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ResultCodes)) {
                    return false;
                }
                ResultCodes other = (ResultCodes)o;
                String this$transactionResultCode = this.getTransactionResultCode();
                String other$transactionResultCode = other.getTransactionResultCode();
                if (this$transactionResultCode == null ? other$transactionResultCode != null : !this$transactionResultCode.equals(other$transactionResultCode)) {
                    return false;
                }
                String this$innerTransactionResultCode = this.getInnerTransactionResultCode();
                String other$innerTransactionResultCode = other.getInnerTransactionResultCode();
                if (this$innerTransactionResultCode == null ? other$innerTransactionResultCode != null : !this$innerTransactionResultCode.equals(other$innerTransactionResultCode)) {
                    return false;
                }
                ArrayList<String> this$operationsResultCodes = this.getOperationsResultCodes();
                ArrayList<String> other$operationsResultCodes = other.getOperationsResultCodes();
                return !(this$operationsResultCodes == null ? other$operationsResultCodes != null : !((Object)this$operationsResultCodes).equals(other$operationsResultCodes));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $transactionResultCode = this.getTransactionResultCode();
                result = result * 59 + ($transactionResultCode == null ? 43 : $transactionResultCode.hashCode());
                String $innerTransactionResultCode = this.getInnerTransactionResultCode();
                result = result * 59 + ($innerTransactionResultCode == null ? 43 : $innerTransactionResultCode.hashCode());
                ArrayList<String> $operationsResultCodes = this.getOperationsResultCodes();
                result = result * 59 + ($operationsResultCodes == null ? 43 : ((Object)$operationsResultCodes).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "SubmitTransactionResponse.Extras.ResultCodes(transactionResultCode=" + this.getTransactionResultCode() + ", innerTransactionResultCode=" + this.getInnerTransactionResultCode() + ", operationsResultCodes=" + this.getOperationsResultCodes() + ")";
            }
        }
    }
}

