/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses.operations;

import com.google.gson.annotations.SerializedName;
import java.math.BigInteger;
import java.util.Optional;
import lombok.Generated;
import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeNative;
import org.stellar.sdk.responses.MuxedAccount;
import org.stellar.sdk.responses.operations.OperationResponse;

public final class PaymentOperationResponse
extends OperationResponse {
    @SerializedName(value="amount")
    private final String amount;
    @SerializedName(value="asset_type")
    private final String assetType;
    @SerializedName(value="asset_code")
    private final String assetCode;
    @SerializedName(value="asset_issuer")
    private final String assetIssuer;
    @SerializedName(value="from")
    private final String from;
    @SerializedName(value="from_muxed")
    private final String fromMuxed;
    @SerializedName(value="from_muxed_id")
    private final BigInteger fromMuxedId;
    @SerializedName(value="to")
    private final String to;
    @SerializedName(value="to_muxed")
    private final String toMuxed;
    @SerializedName(value="to_muxed_id")
    private final BigInteger toMuxedId;

    public Asset getAsset() {
        if (this.assetType.equals("native")) {
            return new AssetTypeNative();
        }
        return Asset.create(this.assetType, this.assetCode, this.assetIssuer);
    }

    public Optional<MuxedAccount> getFromMuxed() {
        if (this.fromMuxed == null || this.fromMuxed.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new MuxedAccount(this.fromMuxed, this.from, this.fromMuxedId));
    }

    public Optional<MuxedAccount> getToMuxed() {
        if (this.toMuxed == null || this.toMuxed.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new MuxedAccount(this.toMuxed, this.to, this.toMuxedId));
    }

    @Generated
    public PaymentOperationResponse(String amount, String assetType, String assetCode, String assetIssuer, String from, String fromMuxed, BigInteger fromMuxedId, String to, String toMuxed, BigInteger toMuxedId) {
        this.amount = amount;
        this.assetType = assetType;
        this.assetCode = assetCode;
        this.assetIssuer = assetIssuer;
        this.from = from;
        this.fromMuxed = fromMuxed;
        this.fromMuxedId = fromMuxedId;
        this.to = to;
        this.toMuxed = toMuxed;
        this.toMuxedId = toMuxedId;
    }

    @Generated
    public String getAmount() {
        return this.amount;
    }

    @Generated
    public String getAssetType() {
        return this.assetType;
    }

    @Generated
    public String getAssetCode() {
        return this.assetCode;
    }

    @Generated
    public String getAssetIssuer() {
        return this.assetIssuer;
    }

    @Generated
    public String getFrom() {
        return this.from;
    }

    @Generated
    public BigInteger getFromMuxedId() {
        return this.fromMuxedId;
    }

    @Generated
    public String getTo() {
        return this.to;
    }

    @Generated
    public BigInteger getToMuxedId() {
        return this.toMuxedId;
    }

    @Generated
    public String toString() {
        return "PaymentOperationResponse(amount=" + this.getAmount() + ", assetType=" + this.getAssetType() + ", assetCode=" + this.getAssetCode() + ", assetIssuer=" + this.getAssetIssuer() + ", from=" + this.getFrom() + ", fromMuxed=" + this.getFromMuxed() + ", fromMuxedId=" + this.getFromMuxedId() + ", to=" + this.getTo() + ", toMuxed=" + this.getToMuxed() + ", toMuxedId=" + this.getToMuxedId() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentOperationResponse)) {
            return false;
        }
        PaymentOperationResponse other = (PaymentOperationResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$amount = this.getAmount();
        String other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) {
            return false;
        }
        String this$assetType = this.getAssetType();
        String other$assetType = other.getAssetType();
        if (this$assetType == null ? other$assetType != null : !this$assetType.equals(other$assetType)) {
            return false;
        }
        String this$assetCode = this.getAssetCode();
        String other$assetCode = other.getAssetCode();
        if (this$assetCode == null ? other$assetCode != null : !this$assetCode.equals(other$assetCode)) {
            return false;
        }
        String this$assetIssuer = this.getAssetIssuer();
        String other$assetIssuer = other.getAssetIssuer();
        if (this$assetIssuer == null ? other$assetIssuer != null : !this$assetIssuer.equals(other$assetIssuer)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        Optional<MuxedAccount> this$fromMuxed = this.getFromMuxed();
        Optional<MuxedAccount> other$fromMuxed = other.getFromMuxed();
        if (this$fromMuxed == null ? other$fromMuxed != null : !((Object)this$fromMuxed).equals(other$fromMuxed)) {
            return false;
        }
        BigInteger this$fromMuxedId = this.getFromMuxedId();
        BigInteger other$fromMuxedId = other.getFromMuxedId();
        if (this$fromMuxedId == null ? other$fromMuxedId != null : !((Object)this$fromMuxedId).equals(other$fromMuxedId)) {
            return false;
        }
        String this$to = this.getTo();
        String other$to = other.getTo();
        if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
            return false;
        }
        Optional<MuxedAccount> this$toMuxed = this.getToMuxed();
        Optional<MuxedAccount> other$toMuxed = other.getToMuxed();
        if (this$toMuxed == null ? other$toMuxed != null : !((Object)this$toMuxed).equals(other$toMuxed)) {
            return false;
        }
        BigInteger this$toMuxedId = this.getToMuxedId();
        BigInteger other$toMuxedId = other.getToMuxedId();
        return !(this$toMuxedId == null ? other$toMuxedId != null : !((Object)this$toMuxedId).equals(other$toMuxedId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PaymentOperationResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : $amount.hashCode());
        String $assetType = this.getAssetType();
        result = result * 59 + ($assetType == null ? 43 : $assetType.hashCode());
        String $assetCode = this.getAssetCode();
        result = result * 59 + ($assetCode == null ? 43 : $assetCode.hashCode());
        String $assetIssuer = this.getAssetIssuer();
        result = result * 59 + ($assetIssuer == null ? 43 : $assetIssuer.hashCode());
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        Optional<MuxedAccount> $fromMuxed = this.getFromMuxed();
        result = result * 59 + ($fromMuxed == null ? 43 : ((Object)$fromMuxed).hashCode());
        BigInteger $fromMuxedId = this.getFromMuxedId();
        result = result * 59 + ($fromMuxedId == null ? 43 : ((Object)$fromMuxedId).hashCode());
        String $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        Optional<MuxedAccount> $toMuxed = this.getToMuxed();
        result = result * 59 + ($toMuxed == null ? 43 : ((Object)$toMuxed).hashCode());
        BigInteger $toMuxedId = this.getToMuxedId();
        result = result * 59 + ($toMuxedId == null ? 43 : ((Object)$toMuxedId).hashCode());
        return result;
    }
}

