/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.AssetCode;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class AllowTrustOp
implements XdrElement {
    private AccountID trustor;
    private AssetCode asset;
    private Uint32 authorize;

    public AccountID getTrustor() {
        return this.trustor;
    }

    public void setTrustor(AccountID value) {
        this.trustor = value;
    }

    public AssetCode getAsset() {
        return this.asset;
    }

    public void setAsset(AssetCode value) {
        this.asset = value;
    }

    public Uint32 getAuthorize() {
        return this.authorize;
    }

    public void setAuthorize(Uint32 value) {
        this.authorize = value;
    }

    public static void encode(XdrDataOutputStream stream, AllowTrustOp encodedAllowTrustOp) throws IOException {
        AccountID.encode(stream, encodedAllowTrustOp.trustor);
        AssetCode.encode(stream, encodedAllowTrustOp.asset);
        Uint32.encode(stream, encodedAllowTrustOp.authorize);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        AllowTrustOp.encode(stream, this);
    }

    public static AllowTrustOp decode(XdrDataInputStream stream) throws IOException {
        AllowTrustOp decodedAllowTrustOp = new AllowTrustOp();
        decodedAllowTrustOp.trustor = AccountID.decode(stream);
        decodedAllowTrustOp.asset = AssetCode.decode(stream);
        decodedAllowTrustOp.authorize = Uint32.decode(stream);
        return decodedAllowTrustOp;
    }

    public int hashCode() {
        return Objects.hash(this.trustor, this.asset, this.authorize);
    }

    public boolean equals(Object object) {
        if (!(object instanceof AllowTrustOp)) {
            return false;
        }
        AllowTrustOp other = (AllowTrustOp)object;
        return Objects.equals(this.trustor, other.trustor) && Objects.equals(this.asset, other.asset) && Objects.equals(this.authorize, other.authorize);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static AllowTrustOp fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return AllowTrustOp.fromXdrByteArray(bytes);
    }

    public static AllowTrustOp fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return AllowTrustOp.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private AccountID trustor;
        private AssetCode asset;
        private Uint32 authorize;

        public Builder trustor(AccountID trustor) {
            this.trustor = trustor;
            return this;
        }

        public Builder asset(AssetCode asset) {
            this.asset = asset;
            return this;
        }

        public Builder authorize(Uint32 authorize) {
            this.authorize = authorize;
            return this;
        }

        public AllowTrustOp build() {
            AllowTrustOp val = new AllowTrustOp();
            val.setTrustor(this.trustor);
            val.setAsset(this.asset);
            val.setAuthorize(this.authorize);
            return val;
        }
    }
}

