/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum ClaimAtomType implements XdrElement
{
    CLAIM_ATOM_TYPE_V0(0),
    CLAIM_ATOM_TYPE_ORDER_BOOK(1),
    CLAIM_ATOM_TYPE_LIQUIDITY_POOL(2);

    private int mValue;

    private ClaimAtomType(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static ClaimAtomType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return CLAIM_ATOM_TYPE_V0;
            }
            case 1: {
                return CLAIM_ATOM_TYPE_ORDER_BOOK;
            }
            case 2: {
                return CLAIM_ATOM_TYPE_LIQUIDITY_POOL;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, ClaimAtomType value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        ClaimAtomType.encode(stream, this);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static ClaimAtomType fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ClaimAtomType.fromXdrByteArray(bytes);
    }

    public static ClaimAtomType fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ClaimAtomType.decode(xdrDataInputStream);
    }
}

