/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class CreateAccountOp
implements XdrElement {
    private AccountID destination;
    private Int64 startingBalance;

    public AccountID getDestination() {
        return this.destination;
    }

    public void setDestination(AccountID value) {
        this.destination = value;
    }

    public Int64 getStartingBalance() {
        return this.startingBalance;
    }

    public void setStartingBalance(Int64 value) {
        this.startingBalance = value;
    }

    public static void encode(XdrDataOutputStream stream, CreateAccountOp encodedCreateAccountOp) throws IOException {
        AccountID.encode(stream, encodedCreateAccountOp.destination);
        Int64.encode(stream, encodedCreateAccountOp.startingBalance);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        CreateAccountOp.encode(stream, this);
    }

    public static CreateAccountOp decode(XdrDataInputStream stream) throws IOException {
        CreateAccountOp decodedCreateAccountOp = new CreateAccountOp();
        decodedCreateAccountOp.destination = AccountID.decode(stream);
        decodedCreateAccountOp.startingBalance = Int64.decode(stream);
        return decodedCreateAccountOp;
    }

    public int hashCode() {
        return Objects.hash(this.destination, this.startingBalance);
    }

    public boolean equals(Object object) {
        if (!(object instanceof CreateAccountOp)) {
            return false;
        }
        CreateAccountOp other = (CreateAccountOp)object;
        return Objects.equals(this.destination, other.destination) && Objects.equals(this.startingBalance, other.startingBalance);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static CreateAccountOp fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return CreateAccountOp.fromXdrByteArray(bytes);
    }

    public static CreateAccountOp fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return CreateAccountOp.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private AccountID destination;
        private Int64 startingBalance;

        public Builder destination(AccountID destination) {
            this.destination = destination;
            return this;
        }

        public Builder startingBalance(Int64 startingBalance) {
            this.startingBalance = startingBalance;
            return this;
        }

        public CreateAccountOp build() {
            CreateAccountOp val = new CreateAccountOp();
            val.setDestination(this.destination);
            val.setStartingBalance(this.startingBalance);
            return val;
        }
    }
}

