/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SCAddress;
import org.stellar.sdk.xdr.SCSymbol;
import org.stellar.sdk.xdr.SCVal;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class InvokeContractArgs
implements XdrElement {
    private SCAddress contractAddress;
    private SCSymbol functionName;
    private SCVal[] args;

    public SCAddress getContractAddress() {
        return this.contractAddress;
    }

    public void setContractAddress(SCAddress value) {
        this.contractAddress = value;
    }

    public SCSymbol getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(SCSymbol value) {
        this.functionName = value;
    }

    public SCVal[] getArgs() {
        return this.args;
    }

    public void setArgs(SCVal[] value) {
        this.args = value;
    }

    public static void encode(XdrDataOutputStream stream, InvokeContractArgs encodedInvokeContractArgs) throws IOException {
        SCAddress.encode(stream, encodedInvokeContractArgs.contractAddress);
        SCSymbol.encode(stream, encodedInvokeContractArgs.functionName);
        int argssize = encodedInvokeContractArgs.getArgs().length;
        stream.writeInt(argssize);
        for (int i = 0; i < argssize; ++i) {
            SCVal.encode(stream, encodedInvokeContractArgs.args[i]);
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        InvokeContractArgs.encode(stream, this);
    }

    public static InvokeContractArgs decode(XdrDataInputStream stream) throws IOException {
        InvokeContractArgs decodedInvokeContractArgs = new InvokeContractArgs();
        decodedInvokeContractArgs.contractAddress = SCAddress.decode(stream);
        decodedInvokeContractArgs.functionName = SCSymbol.decode(stream);
        int argssize = stream.readInt();
        decodedInvokeContractArgs.args = new SCVal[argssize];
        for (int i = 0; i < argssize; ++i) {
            decodedInvokeContractArgs.args[i] = SCVal.decode(stream);
        }
        return decodedInvokeContractArgs;
    }

    public int hashCode() {
        return Objects.hash(this.contractAddress, this.functionName, Arrays.hashCode(this.args));
    }

    public boolean equals(Object object) {
        if (!(object instanceof InvokeContractArgs)) {
            return false;
        }
        InvokeContractArgs other = (InvokeContractArgs)object;
        return Objects.equals(this.contractAddress, other.contractAddress) && Objects.equals(this.functionName, other.functionName) && Arrays.equals(this.args, other.args);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static InvokeContractArgs fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return InvokeContractArgs.fromXdrByteArray(bytes);
    }

    public static InvokeContractArgs fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return InvokeContractArgs.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private SCAddress contractAddress;
        private SCSymbol functionName;
        private SCVal[] args;

        public Builder contractAddress(SCAddress contractAddress) {
            this.contractAddress = contractAddress;
            return this;
        }

        public Builder functionName(SCSymbol functionName) {
            this.functionName = functionName;
            return this;
        }

        public Builder args(SCVal[] args2) {
            this.args = args2;
            return this;
        }

        public InvokeContractArgs build() {
            InvokeContractArgs val = new InvokeContractArgs();
            val.setContractAddress(this.contractAddress);
            val.setFunctionName(this.functionName);
            val.setArgs(this.args);
            return val;
        }
    }
}

