/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ManageDataResultCode;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ManageDataResult
implements XdrElement {
    ManageDataResultCode code;

    public ManageDataResultCode getDiscriminant() {
        return this.code;
    }

    public void setDiscriminant(ManageDataResultCode value) {
        this.code = value;
    }

    public static void encode(XdrDataOutputStream stream, ManageDataResult encodedManageDataResult) throws IOException {
        stream.writeInt(encodedManageDataResult.getDiscriminant().getValue());
        switch (encodedManageDataResult.getDiscriminant()) {
            case MANAGE_DATA_SUCCESS: {
                break;
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        ManageDataResult.encode(stream, this);
    }

    public static ManageDataResult decode(XdrDataInputStream stream) throws IOException {
        ManageDataResult decodedManageDataResult = new ManageDataResult();
        ManageDataResultCode discriminant = ManageDataResultCode.decode(stream);
        decodedManageDataResult.setDiscriminant(discriminant);
        switch (decodedManageDataResult.getDiscriminant()) {
            case MANAGE_DATA_SUCCESS: {
                break;
            }
        }
        return decodedManageDataResult;
    }

    public int hashCode() {
        return Objects.hash(this.code);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ManageDataResult)) {
            return false;
        }
        ManageDataResult other = (ManageDataResult)object;
        return Objects.equals(this.code, other.code);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static ManageDataResult fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ManageDataResult.fromXdrByteArray(bytes);
    }

    public static ManageDataResult fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ManageDataResult.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private ManageDataResultCode discriminant;

        public Builder discriminant(ManageDataResultCode discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public ManageDataResult build() {
            ManageDataResult val = new ManageDataResult();
            val.setDiscriminant(this.discriminant);
            return val;
        }
    }
}

