/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SCSpecTypeDef;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SCSpecTypeMap
implements XdrElement {
    private SCSpecTypeDef keyType;
    private SCSpecTypeDef valueType;

    public SCSpecTypeDef getKeyType() {
        return this.keyType;
    }

    public void setKeyType(SCSpecTypeDef value) {
        this.keyType = value;
    }

    public SCSpecTypeDef getValueType() {
        return this.valueType;
    }

    public void setValueType(SCSpecTypeDef value) {
        this.valueType = value;
    }

    public static void encode(XdrDataOutputStream stream, SCSpecTypeMap encodedSCSpecTypeMap) throws IOException {
        SCSpecTypeDef.encode(stream, encodedSCSpecTypeMap.keyType);
        SCSpecTypeDef.encode(stream, encodedSCSpecTypeMap.valueType);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SCSpecTypeMap.encode(stream, this);
    }

    public static SCSpecTypeMap decode(XdrDataInputStream stream) throws IOException {
        SCSpecTypeMap decodedSCSpecTypeMap = new SCSpecTypeMap();
        decodedSCSpecTypeMap.keyType = SCSpecTypeDef.decode(stream);
        decodedSCSpecTypeMap.valueType = SCSpecTypeDef.decode(stream);
        return decodedSCSpecTypeMap;
    }

    public int hashCode() {
        return Objects.hash(this.keyType, this.valueType);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SCSpecTypeMap)) {
            return false;
        }
        SCSpecTypeMap other = (SCSpecTypeMap)object;
        return Objects.equals(this.keyType, other.keyType) && Objects.equals(this.valueType, other.valueType);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SCSpecTypeMap fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCSpecTypeMap.fromXdrByteArray(bytes);
    }

    public static SCSpecTypeMap fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCSpecTypeMap.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private SCSpecTypeDef keyType;
        private SCSpecTypeDef valueType;

        public Builder keyType(SCSpecTypeDef keyType) {
            this.keyType = keyType;
            return this;
        }

        public Builder valueType(SCSpecTypeDef valueType) {
            this.valueType = valueType;
            return this;
        }

        public SCSpecTypeMap build() {
            SCSpecTypeMap val = new SCSpecTypeMap();
            val.setKeyType(this.keyType);
            val.setValueType(this.valueType);
            return val;
        }
    }
}

