/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SCSpecTypeDef;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import org.stellar.sdk.xdr.XdrString;

public class SCSpecUDTStructFieldV0
implements XdrElement {
    private XdrString doc;
    private XdrString name;
    private SCSpecTypeDef type;

    public XdrString getDoc() {
        return this.doc;
    }

    public void setDoc(XdrString value) {
        this.doc = value;
    }

    public XdrString getName() {
        return this.name;
    }

    public void setName(XdrString value) {
        this.name = value;
    }

    public SCSpecTypeDef getType() {
        return this.type;
    }

    public void setType(SCSpecTypeDef value) {
        this.type = value;
    }

    public static void encode(XdrDataOutputStream stream, SCSpecUDTStructFieldV0 encodedSCSpecUDTStructFieldV0) throws IOException {
        encodedSCSpecUDTStructFieldV0.doc.encode(stream);
        encodedSCSpecUDTStructFieldV0.name.encode(stream);
        SCSpecTypeDef.encode(stream, encodedSCSpecUDTStructFieldV0.type);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SCSpecUDTStructFieldV0.encode(stream, this);
    }

    public static SCSpecUDTStructFieldV0 decode(XdrDataInputStream stream) throws IOException {
        SCSpecUDTStructFieldV0 decodedSCSpecUDTStructFieldV0 = new SCSpecUDTStructFieldV0();
        decodedSCSpecUDTStructFieldV0.doc = XdrString.decode(stream, 1024);
        decodedSCSpecUDTStructFieldV0.name = XdrString.decode(stream, 30);
        decodedSCSpecUDTStructFieldV0.type = SCSpecTypeDef.decode(stream);
        return decodedSCSpecUDTStructFieldV0;
    }

    public int hashCode() {
        return Objects.hash(this.doc, this.name, this.type);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SCSpecUDTStructFieldV0)) {
            return false;
        }
        SCSpecUDTStructFieldV0 other = (SCSpecUDTStructFieldV0)object;
        return Objects.equals(this.doc, other.doc) && Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SCSpecUDTStructFieldV0 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCSpecUDTStructFieldV0.fromXdrByteArray(bytes);
    }

    public static SCSpecUDTStructFieldV0 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCSpecUDTStructFieldV0.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private XdrString doc;
        private XdrString name;
        private SCSpecTypeDef type;

        public Builder doc(XdrString doc) {
            this.doc = doc;
            return this;
        }

        public Builder name(XdrString name) {
            this.name = name;
            return this;
        }

        public Builder type(SCSpecTypeDef type) {
            this.type = type;
            return this;
        }

        public SCSpecUDTStructFieldV0 build() {
            SCSpecUDTStructFieldV0 val = new SCSpecUDTStructFieldV0();
            val.setDoc(this.doc);
            val.setName(this.name);
            val.setType(this.type);
            return val;
        }
    }
}

