/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum SCValType implements XdrElement
{
    SCV_BOOL(0),
    SCV_VOID(1),
    SCV_ERROR(2),
    SCV_U32(3),
    SCV_I32(4),
    SCV_U64(5),
    SCV_I64(6),
    SCV_TIMEPOINT(7),
    SCV_DURATION(8),
    SCV_U128(9),
    SCV_I128(10),
    SCV_U256(11),
    SCV_I256(12),
    SCV_BYTES(13),
    SCV_STRING(14),
    SCV_SYMBOL(15),
    SCV_VEC(16),
    SCV_MAP(17),
    SCV_ADDRESS(18),
    SCV_CONTRACT_INSTANCE(19),
    SCV_LEDGER_KEY_CONTRACT_INSTANCE(20),
    SCV_LEDGER_KEY_NONCE(21);

    private int mValue;

    private SCValType(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static SCValType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return SCV_BOOL;
            }
            case 1: {
                return SCV_VOID;
            }
            case 2: {
                return SCV_ERROR;
            }
            case 3: {
                return SCV_U32;
            }
            case 4: {
                return SCV_I32;
            }
            case 5: {
                return SCV_U64;
            }
            case 6: {
                return SCV_I64;
            }
            case 7: {
                return SCV_TIMEPOINT;
            }
            case 8: {
                return SCV_DURATION;
            }
            case 9: {
                return SCV_U128;
            }
            case 10: {
                return SCV_I128;
            }
            case 11: {
                return SCV_U256;
            }
            case 12: {
                return SCV_I256;
            }
            case 13: {
                return SCV_BYTES;
            }
            case 14: {
                return SCV_STRING;
            }
            case 15: {
                return SCV_SYMBOL;
            }
            case 16: {
                return SCV_VEC;
            }
            case 17: {
                return SCV_MAP;
            }
            case 18: {
                return SCV_ADDRESS;
            }
            case 19: {
                return SCV_CONTRACT_INSTANCE;
            }
            case 20: {
                return SCV_LEDGER_KEY_CONTRACT_INSTANCE;
            }
            case 21: {
                return SCV_LEDGER_KEY_NONCE;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, SCValType value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SCValType.encode(stream, this);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SCValType fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCValType.fromXdrByteArray(bytes);
    }

    public static SCValType fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCValType.decode(xdrDataInputStream);
    }
}

