/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.OperationMeta;
import org.stellar.sdk.xdr.TransactionMetaV1;
import org.stellar.sdk.xdr.TransactionMetaV2;
import org.stellar.sdk.xdr.TransactionMetaV3;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TransactionMeta
implements XdrElement {
    Integer v;
    private OperationMeta[] operations;
    private TransactionMetaV1 v1;
    private TransactionMetaV2 v2;
    private TransactionMetaV3 v3;

    public Integer getDiscriminant() {
        return this.v;
    }

    public void setDiscriminant(Integer value) {
        this.v = value;
    }

    public OperationMeta[] getOperations() {
        return this.operations;
    }

    public void setOperations(OperationMeta[] value) {
        this.operations = value;
    }

    public TransactionMetaV1 getV1() {
        return this.v1;
    }

    public void setV1(TransactionMetaV1 value) {
        this.v1 = value;
    }

    public TransactionMetaV2 getV2() {
        return this.v2;
    }

    public void setV2(TransactionMetaV2 value) {
        this.v2 = value;
    }

    public TransactionMetaV3 getV3() {
        return this.v3;
    }

    public void setV3(TransactionMetaV3 value) {
        this.v3 = value;
    }

    public static void encode(XdrDataOutputStream stream, TransactionMeta encodedTransactionMeta) throws IOException {
        stream.writeInt(encodedTransactionMeta.getDiscriminant());
        switch (encodedTransactionMeta.getDiscriminant()) {
            case 0: {
                int operationssize = encodedTransactionMeta.getOperations().length;
                stream.writeInt(operationssize);
                for (int i = 0; i < operationssize; ++i) {
                    OperationMeta.encode(stream, encodedTransactionMeta.operations[i]);
                }
                break;
            }
            case 1: {
                TransactionMetaV1.encode(stream, encodedTransactionMeta.v1);
                break;
            }
            case 2: {
                TransactionMetaV2.encode(stream, encodedTransactionMeta.v2);
                break;
            }
            case 3: {
                TransactionMetaV3.encode(stream, encodedTransactionMeta.v3);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        TransactionMeta.encode(stream, this);
    }

    public static TransactionMeta decode(XdrDataInputStream stream) throws IOException {
        TransactionMeta decodedTransactionMeta = new TransactionMeta();
        Integer discriminant = stream.readInt();
        decodedTransactionMeta.setDiscriminant(discriminant);
        switch (decodedTransactionMeta.getDiscriminant()) {
            case 0: {
                int operationssize = stream.readInt();
                decodedTransactionMeta.operations = new OperationMeta[operationssize];
                for (int i = 0; i < operationssize; ++i) {
                    decodedTransactionMeta.operations[i] = OperationMeta.decode(stream);
                }
                break;
            }
            case 1: {
                decodedTransactionMeta.v1 = TransactionMetaV1.decode(stream);
                break;
            }
            case 2: {
                decodedTransactionMeta.v2 = TransactionMetaV2.decode(stream);
                break;
            }
            case 3: {
                decodedTransactionMeta.v3 = TransactionMetaV3.decode(stream);
            }
        }
        return decodedTransactionMeta;
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.operations), this.v1, this.v2, this.v3, this.v);
    }

    public boolean equals(Object object) {
        if (!(object instanceof TransactionMeta)) {
            return false;
        }
        TransactionMeta other = (TransactionMeta)object;
        return Arrays.equals(this.operations, other.operations) && Objects.equals(this.v1, other.v1) && Objects.equals(this.v2, other.v2) && Objects.equals(this.v3, other.v3) && Objects.equals(this.v, other.v);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static TransactionMeta fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TransactionMeta.fromXdrByteArray(bytes);
    }

    public static TransactionMeta fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TransactionMeta.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private Integer discriminant;
        private OperationMeta[] operations;
        private TransactionMetaV1 v1;
        private TransactionMetaV2 v2;
        private TransactionMetaV3 v3;

        public Builder discriminant(Integer discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder operations(OperationMeta[] operations) {
            this.operations = operations;
            return this;
        }

        public Builder v1(TransactionMetaV1 v1) {
            this.v1 = v1;
            return this;
        }

        public Builder v2(TransactionMetaV2 v2) {
            this.v2 = v2;
            return this;
        }

        public Builder v3(TransactionMetaV3 v3) {
            this.v3 = v3;
            return this;
        }

        public TransactionMeta build() {
            TransactionMeta val = new TransactionMeta();
            val.setDiscriminant(this.discriminant);
            val.setOperations(this.operations);
            val.setV1(this.v1);
            val.setV2(this.v2);
            val.setV3(this.v3);
            return val;
        }
    }
}

