/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.FeeBumpTransaction;
import org.stellar.sdk.KeyPair;
import org.stellar.sdk.Network;
import org.stellar.sdk.Transaction;
import org.stellar.sdk.Util;
import org.stellar.sdk.xdr.DecoratedSignature;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.Signature;
import org.stellar.sdk.xdr.SignatureHint;
import org.stellar.sdk.xdr.TransactionEnvelope;
import org.stellar.sdk.xdr.TransactionSignaturePayload;

public abstract class AbstractTransaction {
    @NonNull
    protected final Network network;
    @NonNull
    protected final AccountConverter accountConverter;
    @NonNull
    protected List<DecoratedSignature> signatures;
    public static final int MIN_BASE_FEE = 100;

    AbstractTransaction(@NonNull AccountConverter accountConverter, @NonNull Network network) {
        if (accountConverter == null) {
            throw new NullPointerException("accountConverter is marked non-null but is null");
        }
        if (network == null) {
            throw new NullPointerException("network is marked non-null but is null");
        }
        this.accountConverter = accountConverter;
        this.network = network;
        this.signatures = new ArrayList<DecoratedSignature>();
    }

    public void sign(@NonNull KeyPair signer) {
        if (signer == null) {
            throw new NullPointerException("signer is marked non-null but is null");
        }
        byte[] txHash = this.hash();
        this.signatures.add(signer.signDecorated(txHash));
    }

    public void sign(byte @NonNull [] preimage) {
        if (preimage == null) {
            throw new NullPointerException("preimage is marked non-null but is null");
        }
        Signature signature = new Signature();
        signature.setSignature(preimage);
        byte[] hash = Util.hash(preimage);
        byte[] signatureHintBytes = Arrays.copyOfRange(hash, hash.length - 4, hash.length);
        SignatureHint signatureHint = new SignatureHint();
        signatureHint.setSignatureHint(signatureHintBytes);
        DecoratedSignature decoratedSignature = new DecoratedSignature();
        decoratedSignature.setHint(signatureHint);
        decoratedSignature.setSignature(signature);
        this.signatures.add(decoratedSignature);
    }

    public byte[] hash() {
        return Util.hash(this.signatureBase());
    }

    public String hashHex() {
        return Util.bytesToHex(this.hash()).toLowerCase();
    }

    public abstract byte[] signatureBase();

    public List<DecoratedSignature> getSignatures() {
        return Collections.unmodifiableList(this.signatures);
    }

    public void addSignature(DecoratedSignature signature) {
        this.signatures.add(signature);
    }

    public abstract TransactionEnvelope toEnvelopeXdr();

    public String toEnvelopeXdrBase64() {
        try {
            return this.toEnvelopeXdr().toXdrBase64();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static AbstractTransaction fromEnvelopeXdr(AccountConverter accountConverter, TransactionEnvelope envelope, Network network) {
        switch (envelope.getDiscriminant()) {
            case ENVELOPE_TYPE_TX: {
                return Transaction.fromV1EnvelopeXdr(accountConverter, envelope.getV1(), network);
            }
            case ENVELOPE_TYPE_TX_V0: {
                return Transaction.fromV0EnvelopeXdr(accountConverter, envelope.getV0(), network);
            }
            case ENVELOPE_TYPE_TX_FEE_BUMP: {
                return FeeBumpTransaction.fromFeeBumpTransactionEnvelope(accountConverter, envelope.getFeeBump(), network);
            }
        }
        throw new IllegalArgumentException("transaction type is not supported: " + envelope.getDiscriminant());
    }

    public static AbstractTransaction fromEnvelopeXdr(TransactionEnvelope envelope, Network network) {
        return AbstractTransaction.fromEnvelopeXdr(AccountConverter.enableMuxed(), envelope, network);
    }

    public static AbstractTransaction fromEnvelopeXdr(AccountConverter accountConverter, String envelope, Network network) throws IOException {
        TransactionEnvelope transactionEnvelope = TransactionEnvelope.fromXdrBase64(envelope);
        return AbstractTransaction.fromEnvelopeXdr(accountConverter, transactionEnvelope, network);
    }

    public static AbstractTransaction fromEnvelopeXdr(String envelope, Network network) throws IOException {
        return AbstractTransaction.fromEnvelopeXdr(AccountConverter.enableMuxed(), envelope, network);
    }

    public static byte[] getTransactionSignatureBase(TransactionSignaturePayload.TransactionSignaturePayloadTaggedTransaction taggedTransaction, Network network) {
        try {
            Hash networkIdHash = new Hash(network.getNetworkId());
            TransactionSignaturePayload payload = new TransactionSignaturePayload.Builder().networkId(networkIdHash).taggedTransaction(taggedTransaction).build();
            return payload.toXdrByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    @Generated
    public Network getNetwork() {
        return this.network;
    }

    @NonNull
    @Generated
    public AccountConverter getAccountConverter() {
        return this.accountConverter;
    }
}

