/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Asset;
import org.stellar.sdk.Operation;
import org.stellar.sdk.Predicate;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.xdr.Claimant;
import org.stellar.sdk.xdr.ClaimantType;
import org.stellar.sdk.xdr.CreateClaimableBalanceOp;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;

public class CreateClaimableBalanceOperation
extends Operation {
    @NonNull
    private final String amount;
    @NonNull
    private final Asset asset;
    private final List<org.stellar.sdk.Claimant> claimants;

    private CreateClaimableBalanceOperation(@NonNull String amount, @NonNull Asset asset, @NonNull List<org.stellar.sdk.Claimant> claimants) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (claimants == null) {
            throw new NullPointerException("claimants is marked non-null but is null");
        }
        this.asset = asset;
        this.amount = amount;
        this.claimants = claimants;
        if (this.claimants.isEmpty()) {
            throw new IllegalArgumentException("claimants cannot be empty");
        }
    }

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        CreateClaimableBalanceOp op = new CreateClaimableBalanceOp();
        op.setAsset(this.asset.toXdr());
        Int64 amount = new Int64();
        amount.setInt64(Operation.toXdrAmount(this.amount));
        op.setAmount(amount);
        Claimant[] xdrClaimants = new Claimant[this.claimants.size()];
        for (int i = 0; i < this.claimants.size(); ++i) {
            Claimant.ClaimantV0 v0 = new Claimant.ClaimantV0();
            v0.setDestination(StrKey.encodeToXDRAccountId(this.claimants.get(i).getDestination()));
            v0.setPredicate(this.claimants.get(i).getPredicate().toXdr());
            xdrClaimants[i] = new Claimant();
            xdrClaimants[i].setDiscriminant(ClaimantType.CLAIMANT_TYPE_V0);
            xdrClaimants[i].setV0(v0);
        }
        op.setClaimants(xdrClaimants);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.CREATE_CLAIMABLE_BALANCE);
        body.setCreateClaimableBalanceOp(op);
        return body;
    }

    @NonNull
    @Generated
    public String getAmount() {
        return this.amount;
    }

    @NonNull
    @Generated
    public Asset getAsset() {
        return this.asset;
    }

    @Generated
    public List<org.stellar.sdk.Claimant> getClaimants() {
        return this.claimants;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateClaimableBalanceOperation)) {
            return false;
        }
        CreateClaimableBalanceOperation other = (CreateClaimableBalanceOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$amount = this.getAmount();
        String other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) {
            return false;
        }
        Asset this$asset = this.getAsset();
        Asset other$asset = other.getAsset();
        if (this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset)) {
            return false;
        }
        List<org.stellar.sdk.Claimant> this$claimants = this.getClaimants();
        List<org.stellar.sdk.Claimant> other$claimants = other.getClaimants();
        return !(this$claimants == null ? other$claimants != null : !((Object)this$claimants).equals(other$claimants));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CreateClaimableBalanceOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : $amount.hashCode());
        Asset $asset = this.getAsset();
        result = result * 59 + ($asset == null ? 43 : $asset.hashCode());
        List<org.stellar.sdk.Claimant> $claimants = this.getClaimants();
        result = result * 59 + ($claimants == null ? 43 : ((Object)$claimants).hashCode());
        return result;
    }

    public static class Builder {
        private final String amount;
        private final Asset asset;
        private final List<org.stellar.sdk.Claimant> claimants;
        private String sourceAccount;

        Builder(CreateClaimableBalanceOp op) {
            this.asset = Asset.fromXdr(op.getAsset());
            this.amount = Operation.fromXdrAmount(op.getAmount().getInt64());
            this.claimants = new ArrayList<org.stellar.sdk.Claimant>();
            for (Claimant c : op.getClaimants()) {
                this.claimants.add(new org.stellar.sdk.Claimant(StrKey.encodeEd25519PublicKey(c.getV0().getDestination()), Predicate.fromXdr(c.getV0().getPredicate())));
            }
        }

        public Builder(String amount, Asset asset, List<org.stellar.sdk.Claimant> claimants) {
            this.amount = amount;
            this.asset = asset;
            this.claimants = claimants;
        }

        public Builder setSourceAccount(@NonNull String sourceAccount) {
            if (sourceAccount == null) {
                throw new NullPointerException("sourceAccount is marked non-null but is null");
            }
            this.sourceAccount = sourceAccount;
            return this;
        }

        public CreateClaimableBalanceOperation build() {
            CreateClaimableBalanceOperation operation = new CreateClaimableBalanceOperation(this.amount, this.asset, this.claimants);
            if (this.sourceAccount != null) {
                operation.setSourceAccount(this.sourceAccount);
            }
            return operation;
        }
    }
}

