/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;
import net.i2p.crypto.eddsa.EdDSAEngine;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.KeyPairGenerator;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import org.stellar.sdk.SLIP10;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.DecoratedSignature;
import org.stellar.sdk.xdr.PublicKey;
import org.stellar.sdk.xdr.PublicKeyType;
import org.stellar.sdk.xdr.Signature;
import org.stellar.sdk.xdr.SignatureHint;
import org.stellar.sdk.xdr.SignerKey;
import org.stellar.sdk.xdr.SignerKeyType;
import org.stellar.sdk.xdr.Uint256;
import org.stellar.sdk.xdr.XdrDataOutputStream;

public class KeyPair {
    private static final EdDSANamedCurveSpec ed25519 = EdDSANamedCurveTable.ED_25519_CURVE_SPEC;
    private final EdDSAPublicKey publicKey;
    private final EdDSAPrivateKey privateKey;

    public KeyPair(EdDSAPublicKey publicKey) {
        this(publicKey, null);
    }

    public KeyPair(@NonNull EdDSAPublicKey publicKey, EdDSAPrivateKey privateKey) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public boolean canSign() {
        return this.privateKey != null;
    }

    public static KeyPair fromSecretSeed(char[] seed) {
        byte[] decoded = StrKey.decodeEd25519SecretSeed(seed);
        return KeyPair.fromSecretSeed(decoded);
    }

    public static KeyPair fromSecretSeed(String seed) {
        char[] charSeed = seed.toCharArray();
        byte[] decoded = StrKey.decodeEd25519SecretSeed(charSeed);
        KeyPair keypair = KeyPair.fromSecretSeed(decoded);
        Arrays.fill(charSeed, ' ');
        return keypair;
    }

    public static KeyPair fromSecretSeed(byte[] seed) {
        EdDSAPrivateKeySpec privKeySpec = new EdDSAPrivateKeySpec(seed, (EdDSAParameterSpec)ed25519);
        EdDSAPublicKeySpec publicKeySpec = new EdDSAPublicKeySpec(privKeySpec.getA().toByteArray(), (EdDSAParameterSpec)ed25519);
        return new KeyPair(new EdDSAPublicKey(publicKeySpec), new EdDSAPrivateKey(privKeySpec));
    }

    public static KeyPair fromAccountId(String accountId) {
        byte[] decoded = StrKey.decodeEd25519PublicKey(accountId);
        return KeyPair.fromPublicKey(decoded);
    }

    public static KeyPair fromPublicKey(byte[] publicKey) {
        EdDSAPublicKeySpec publicKeySpec;
        try {
            publicKeySpec = new EdDSAPublicKeySpec(publicKey, (EdDSAParameterSpec)ed25519);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Public key is invalid");
        }
        return new KeyPair(new EdDSAPublicKey(publicKeySpec));
    }

    public static KeyPair fromBip39Seed(byte[] bip39Seed, int accountNumber) {
        try {
            return KeyPair.fromSecretSeed(SLIP10.deriveEd25519PrivateKey(bip39Seed, 44, 148, accountNumber));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static KeyPair random() {
        java.security.KeyPair keypair = new KeyPairGenerator().generateKeyPair();
        return new KeyPair((EdDSAPublicKey)keypair.getPublic(), (EdDSAPrivateKey)keypair.getPrivate());
    }

    public String getAccountId() {
        return StrKey.encodeEd25519PublicKey(this.publicKey.getAbyte());
    }

    public char[] getSecretSeed() {
        return StrKey.encodeEd25519SecretSeed(this.privateKey.getSeed());
    }

    public byte[] getPublicKey() {
        return this.publicKey.getAbyte();
    }

    public SignatureHint getSignatureHint() {
        try {
            ByteArrayOutputStream publicKeyBytesStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrOutputStream = new XdrDataOutputStream(publicKeyBytesStream);
            PublicKey.encode(xdrOutputStream, this.getXdrPublicKey());
            byte[] publicKeyBytes = publicKeyBytesStream.toByteArray();
            byte[] signatureHintBytes = Arrays.copyOfRange(publicKeyBytes, publicKeyBytes.length - 4, publicKeyBytes.length);
            SignatureHint signatureHint = new SignatureHint();
            signatureHint.setSignatureHint(signatureHintBytes);
            return signatureHint;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public PublicKey getXdrPublicKey() {
        PublicKey publicKey = new PublicKey();
        publicKey.setDiscriminant(PublicKeyType.PUBLIC_KEY_TYPE_ED25519);
        Uint256 uint256 = new Uint256();
        uint256.setUint256(this.getPublicKey());
        publicKey.setEd25519(uint256);
        return publicKey;
    }

    public AccountID getXdrAccountId() {
        AccountID accountID = new AccountID();
        accountID.setAccountID(this.getXdrPublicKey());
        return accountID;
    }

    public SignerKey getXdrSignerKey() {
        SignerKey signerKey = new SignerKey();
        signerKey.setDiscriminant(SignerKeyType.SIGNER_KEY_TYPE_ED25519);
        Uint256 uint256 = new Uint256();
        uint256.setUint256(this.getPublicKey());
        signerKey.setEd25519(uint256);
        return signerKey;
    }

    public static KeyPair fromXdrPublicKey(PublicKey key) {
        return KeyPair.fromPublicKey(key.getEd25519().getUint256());
    }

    public static KeyPair fromXdrSignerKey(SignerKey key) {
        return KeyPair.fromPublicKey(key.getEd25519().getUint256());
    }

    public byte[] sign(byte[] data) {
        if (this.privateKey == null) {
            throw new RuntimeException("KeyPair does not contain secret key. Use KeyPair.fromSecretSeed method to create a new KeyPair with a secret key.");
        }
        try {
            EdDSAEngine sgr = new EdDSAEngine(MessageDigest.getInstance("SHA-512"));
            sgr.initSign((PrivateKey)this.privateKey);
            sgr.update(data);
            return sgr.sign();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public DecoratedSignature signDecorated(byte[] data) {
        byte[] signatureBytes = this.sign(data);
        Signature signature = new Signature();
        signature.setSignature(signatureBytes);
        DecoratedSignature decoratedSignature = new DecoratedSignature();
        decoratedSignature.setHint(this.getSignatureHint());
        decoratedSignature.setSignature(signature);
        return decoratedSignature;
    }

    public DecoratedSignature signPayloadDecorated(byte[] signerPayload) {
        DecoratedSignature payloadSignature = this.signDecorated(signerPayload);
        byte[] hint = new byte[4];
        if (signerPayload.length >= hint.length) {
            System.arraycopy(signerPayload, signerPayload.length - hint.length, hint, 0, hint.length);
        } else {
            System.arraycopy(signerPayload, 0, hint, 0, signerPayload.length);
        }
        for (int i = 0; i < hint.length; ++i) {
            int n = i;
            hint[n] = (byte)(hint[n] ^ payloadSignature.getHint().getSignatureHint()[i]);
        }
        payloadSignature.getHint().setSignatureHint(hint);
        return payloadSignature;
    }

    public boolean verify(byte[] data, byte[] signature) {
        try {
            EdDSAEngine sgr = new EdDSAEngine(MessageDigest.getInstance("SHA-512"));
            sgr.initVerify((java.security.PublicKey)this.publicKey);
            sgr.update(data);
            return sgr.verify(signature);
        }
        catch (SignatureException e) {
            return false;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyPair)) {
            return false;
        }
        KeyPair other = (KeyPair)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getPublicKey(), other.getPublicKey())) {
            return false;
        }
        EdDSAPrivateKey this$privateKey = this.privateKey;
        EdDSAPrivateKey other$privateKey = other.privateKey;
        return !(this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KeyPair;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getPublicKey());
        EdDSAPrivateKey $privateKey = this.privateKey;
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        return result;
    }
}

