/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.AssetCode12;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class AlphaNum12
implements XdrElement {
    private AssetCode12 assetCode;
    private AccountID issuer;

    public AssetCode12 getAssetCode() {
        return this.assetCode;
    }

    public void setAssetCode(AssetCode12 value) {
        this.assetCode = value;
    }

    public AccountID getIssuer() {
        return this.issuer;
    }

    public void setIssuer(AccountID value) {
        this.issuer = value;
    }

    public static void encode(XdrDataOutputStream stream, AlphaNum12 encodedAlphaNum12) throws IOException {
        AssetCode12.encode(stream, encodedAlphaNum12.assetCode);
        AccountID.encode(stream, encodedAlphaNum12.issuer);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        AlphaNum12.encode(stream, this);
    }

    public static AlphaNum12 decode(XdrDataInputStream stream) throws IOException {
        AlphaNum12 decodedAlphaNum12 = new AlphaNum12();
        decodedAlphaNum12.assetCode = AssetCode12.decode(stream);
        decodedAlphaNum12.issuer = AccountID.decode(stream);
        return decodedAlphaNum12;
    }

    public int hashCode() {
        return Objects.hash(this.assetCode, this.issuer);
    }

    public boolean equals(Object object) {
        if (!(object instanceof AlphaNum12)) {
            return false;
        }
        AlphaNum12 other = (AlphaNum12)object;
        return Objects.equals(this.assetCode, other.assetCode) && Objects.equals(this.issuer, other.issuer);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static AlphaNum12 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return AlphaNum12.fromXdrByteArray(bytes);
    }

    public static AlphaNum12 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return AlphaNum12.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private AssetCode12 assetCode;
        private AccountID issuer;

        public Builder assetCode(AssetCode12 assetCode) {
            this.assetCode = assetCode;
            return this;
        }

        public Builder issuer(AccountID issuer) {
            this.issuer = issuer;
            return this;
        }

        public AlphaNum12 build() {
            AlphaNum12 val = new AlphaNum12();
            val.setAssetCode(this.assetCode);
            val.setIssuer(this.issuer);
            return val;
        }
    }
}

