/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.MuxedAccount;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ClawbackOp
implements XdrElement {
    private Asset asset;
    private MuxedAccount from;
    private Int64 amount;

    public Asset getAsset() {
        return this.asset;
    }

    public void setAsset(Asset value) {
        this.asset = value;
    }

    public MuxedAccount getFrom() {
        return this.from;
    }

    public void setFrom(MuxedAccount value) {
        this.from = value;
    }

    public Int64 getAmount() {
        return this.amount;
    }

    public void setAmount(Int64 value) {
        this.amount = value;
    }

    public static void encode(XdrDataOutputStream stream, ClawbackOp encodedClawbackOp) throws IOException {
        Asset.encode(stream, encodedClawbackOp.asset);
        MuxedAccount.encode(stream, encodedClawbackOp.from);
        Int64.encode(stream, encodedClawbackOp.amount);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        ClawbackOp.encode(stream, this);
    }

    public static ClawbackOp decode(XdrDataInputStream stream) throws IOException {
        ClawbackOp decodedClawbackOp = new ClawbackOp();
        decodedClawbackOp.asset = Asset.decode(stream);
        decodedClawbackOp.from = MuxedAccount.decode(stream);
        decodedClawbackOp.amount = Int64.decode(stream);
        return decodedClawbackOp;
    }

    public int hashCode() {
        return Objects.hash(this.asset, this.from, this.amount);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClawbackOp)) {
            return false;
        }
        ClawbackOp other = (ClawbackOp)object;
        return Objects.equals(this.asset, other.asset) && Objects.equals(this.from, other.from) && Objects.equals(this.amount, other.amount);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static ClawbackOp fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ClawbackOp.fromXdrByteArray(bytes);
    }

    public static ClawbackOp fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ClawbackOp.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private Asset asset;
        private MuxedAccount from;
        private Int64 amount;

        public Builder asset(Asset asset) {
            this.asset = asset;
            return this;
        }

        public Builder from(MuxedAccount from) {
            this.from = from;
            return this;
        }

        public Builder amount(Int64 amount) {
            this.amount = amount;
            return this;
        }

        public ClawbackOp build() {
            ClawbackOp val = new ClawbackOp();
            val.setAsset(this.asset);
            val.setFrom(this.from);
            val.setAmount(this.amount);
            return val;
        }
    }
}

