/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ClaimableBalanceID;
import org.stellar.sdk.xdr.CreateClaimableBalanceResultCode;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class CreateClaimableBalanceResult
implements XdrElement {
    CreateClaimableBalanceResultCode code;
    private ClaimableBalanceID balanceID;

    public CreateClaimableBalanceResultCode getDiscriminant() {
        return this.code;
    }

    public void setDiscriminant(CreateClaimableBalanceResultCode value) {
        this.code = value;
    }

    public ClaimableBalanceID getBalanceID() {
        return this.balanceID;
    }

    public void setBalanceID(ClaimableBalanceID value) {
        this.balanceID = value;
    }

    public static void encode(XdrDataOutputStream stream, CreateClaimableBalanceResult encodedCreateClaimableBalanceResult) throws IOException {
        stream.writeInt(encodedCreateClaimableBalanceResult.getDiscriminant().getValue());
        switch (encodedCreateClaimableBalanceResult.getDiscriminant()) {
            case CREATE_CLAIMABLE_BALANCE_SUCCESS: {
                ClaimableBalanceID.encode(stream, encodedCreateClaimableBalanceResult.balanceID);
                break;
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        CreateClaimableBalanceResult.encode(stream, this);
    }

    public static CreateClaimableBalanceResult decode(XdrDataInputStream stream) throws IOException {
        CreateClaimableBalanceResult decodedCreateClaimableBalanceResult = new CreateClaimableBalanceResult();
        CreateClaimableBalanceResultCode discriminant = CreateClaimableBalanceResultCode.decode(stream);
        decodedCreateClaimableBalanceResult.setDiscriminant(discriminant);
        switch (decodedCreateClaimableBalanceResult.getDiscriminant()) {
            case CREATE_CLAIMABLE_BALANCE_SUCCESS: {
                decodedCreateClaimableBalanceResult.balanceID = ClaimableBalanceID.decode(stream);
                break;
            }
        }
        return decodedCreateClaimableBalanceResult;
    }

    public int hashCode() {
        return Objects.hash(this.balanceID, this.code);
    }

    public boolean equals(Object object) {
        if (!(object instanceof CreateClaimableBalanceResult)) {
            return false;
        }
        CreateClaimableBalanceResult other = (CreateClaimableBalanceResult)object;
        return Objects.equals(this.balanceID, other.balanceID) && Objects.equals(this.code, other.code);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static CreateClaimableBalanceResult fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return CreateClaimableBalanceResult.fromXdrByteArray(bytes);
    }

    public static CreateClaimableBalanceResult fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return CreateClaimableBalanceResult.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private CreateClaimableBalanceResultCode discriminant;
        private ClaimableBalanceID balanceID;

        public Builder discriminant(CreateClaimableBalanceResultCode discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder balanceID(ClaimableBalanceID balanceID) {
            this.balanceID = balanceID;
            return this;
        }

        public CreateClaimableBalanceResult build() {
            CreateClaimableBalanceResult val = new CreateClaimableBalanceResult();
            val.setDiscriminant(this.discriminant);
            val.setBalanceID(this.balanceID);
            return val;
        }
    }
}

