/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class EvictionIterator
implements XdrElement {
    private Uint32 bucketListLevel;
    private Boolean isCurrBucket;
    private Uint64 bucketFileOffset;

    public Uint32 getBucketListLevel() {
        return this.bucketListLevel;
    }

    public void setBucketListLevel(Uint32 value) {
        this.bucketListLevel = value;
    }

    public Boolean getIsCurrBucket() {
        return this.isCurrBucket;
    }

    public void setIsCurrBucket(Boolean value) {
        this.isCurrBucket = value;
    }

    public Uint64 getBucketFileOffset() {
        return this.bucketFileOffset;
    }

    public void setBucketFileOffset(Uint64 value) {
        this.bucketFileOffset = value;
    }

    public static void encode(XdrDataOutputStream stream, EvictionIterator encodedEvictionIterator) throws IOException {
        Uint32.encode(stream, encodedEvictionIterator.bucketListLevel);
        stream.writeInt(encodedEvictionIterator.isCurrBucket != false ? 1 : 0);
        Uint64.encode(stream, encodedEvictionIterator.bucketFileOffset);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        EvictionIterator.encode(stream, this);
    }

    public static EvictionIterator decode(XdrDataInputStream stream) throws IOException {
        EvictionIterator decodedEvictionIterator = new EvictionIterator();
        decodedEvictionIterator.bucketListLevel = Uint32.decode(stream);
        decodedEvictionIterator.isCurrBucket = stream.readInt() == 1;
        decodedEvictionIterator.bucketFileOffset = Uint64.decode(stream);
        return decodedEvictionIterator;
    }

    public int hashCode() {
        return Objects.hash(this.bucketListLevel, this.isCurrBucket, this.bucketFileOffset);
    }

    public boolean equals(Object object) {
        if (!(object instanceof EvictionIterator)) {
            return false;
        }
        EvictionIterator other = (EvictionIterator)object;
        return Objects.equals(this.bucketListLevel, other.bucketListLevel) && Objects.equals(this.isCurrBucket, other.isCurrBucket) && Objects.equals(this.bucketFileOffset, other.bucketFileOffset);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static EvictionIterator fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return EvictionIterator.fromXdrByteArray(bytes);
    }

    public static EvictionIterator fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return EvictionIterator.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private Uint32 bucketListLevel;
        private Boolean isCurrBucket;
        private Uint64 bucketFileOffset;

        public Builder bucketListLevel(Uint32 bucketListLevel) {
            this.bucketListLevel = bucketListLevel;
            return this;
        }

        public Builder isCurrBucket(Boolean isCurrBucket) {
            this.isCurrBucket = isCurrBucket;
            return this;
        }

        public Builder bucketFileOffset(Uint64 bucketFileOffset) {
            this.bucketFileOffset = bucketFileOffset;
            return this;
        }

        public EvictionIterator build() {
            EvictionIterator val = new EvictionIterator();
            val.setBucketListLevel(this.bucketListLevel);
            val.setIsCurrBucket(this.isCurrBucket);
            val.setBucketFileOffset(this.bucketFileOffset);
            return val;
        }
    }
}

