/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.DecoratedSignature;
import org.stellar.sdk.xdr.FeeBumpTransaction;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class FeeBumpTransactionEnvelope
implements XdrElement {
    private FeeBumpTransaction tx;
    private DecoratedSignature[] signatures;

    public FeeBumpTransaction getTx() {
        return this.tx;
    }

    public void setTx(FeeBumpTransaction value) {
        this.tx = value;
    }

    public DecoratedSignature[] getSignatures() {
        return this.signatures;
    }

    public void setSignatures(DecoratedSignature[] value) {
        this.signatures = value;
    }

    public static void encode(XdrDataOutputStream stream, FeeBumpTransactionEnvelope encodedFeeBumpTransactionEnvelope) throws IOException {
        FeeBumpTransaction.encode(stream, encodedFeeBumpTransactionEnvelope.tx);
        int signaturessize = encodedFeeBumpTransactionEnvelope.getSignatures().length;
        stream.writeInt(signaturessize);
        for (int i = 0; i < signaturessize; ++i) {
            DecoratedSignature.encode(stream, encodedFeeBumpTransactionEnvelope.signatures[i]);
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        FeeBumpTransactionEnvelope.encode(stream, this);
    }

    public static FeeBumpTransactionEnvelope decode(XdrDataInputStream stream) throws IOException {
        FeeBumpTransactionEnvelope decodedFeeBumpTransactionEnvelope = new FeeBumpTransactionEnvelope();
        decodedFeeBumpTransactionEnvelope.tx = FeeBumpTransaction.decode(stream);
        int signaturessize = stream.readInt();
        decodedFeeBumpTransactionEnvelope.signatures = new DecoratedSignature[signaturessize];
        for (int i = 0; i < signaturessize; ++i) {
            decodedFeeBumpTransactionEnvelope.signatures[i] = DecoratedSignature.decode(stream);
        }
        return decodedFeeBumpTransactionEnvelope;
    }

    public int hashCode() {
        return Objects.hash(this.tx, Arrays.hashCode(this.signatures));
    }

    public boolean equals(Object object) {
        if (!(object instanceof FeeBumpTransactionEnvelope)) {
            return false;
        }
        FeeBumpTransactionEnvelope other = (FeeBumpTransactionEnvelope)object;
        return Objects.equals(this.tx, other.tx) && Arrays.equals(this.signatures, other.signatures);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static FeeBumpTransactionEnvelope fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return FeeBumpTransactionEnvelope.fromXdrByteArray(bytes);
    }

    public static FeeBumpTransactionEnvelope fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return FeeBumpTransactionEnvelope.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private FeeBumpTransaction tx;
        private DecoratedSignature[] signatures;

        public Builder tx(FeeBumpTransaction tx) {
            this.tx = tx;
            return this;
        }

        public Builder signatures(DecoratedSignature[] signatures) {
            this.signatures = signatures;
            return this;
        }

        public FeeBumpTransactionEnvelope build() {
            FeeBumpTransactionEnvelope val = new FeeBumpTransactionEnvelope();
            val.setTx(this.tx);
            val.setSignatures(this.signatures);
            return val;
        }
    }
}

