/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.LedgerCloseMetaV0;
import org.stellar.sdk.xdr.LedgerCloseMetaV1;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class LedgerCloseMeta
implements XdrElement {
    Integer v;
    private LedgerCloseMetaV0 v0;
    private LedgerCloseMetaV1 v1;

    public Integer getDiscriminant() {
        return this.v;
    }

    public void setDiscriminant(Integer value) {
        this.v = value;
    }

    public LedgerCloseMetaV0 getV0() {
        return this.v0;
    }

    public void setV0(LedgerCloseMetaV0 value) {
        this.v0 = value;
    }

    public LedgerCloseMetaV1 getV1() {
        return this.v1;
    }

    public void setV1(LedgerCloseMetaV1 value) {
        this.v1 = value;
    }

    public static void encode(XdrDataOutputStream stream, LedgerCloseMeta encodedLedgerCloseMeta) throws IOException {
        stream.writeInt(encodedLedgerCloseMeta.getDiscriminant());
        switch (encodedLedgerCloseMeta.getDiscriminant()) {
            case 0: {
                LedgerCloseMetaV0.encode(stream, encodedLedgerCloseMeta.v0);
                break;
            }
            case 1: {
                LedgerCloseMetaV1.encode(stream, encodedLedgerCloseMeta.v1);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        LedgerCloseMeta.encode(stream, this);
    }

    public static LedgerCloseMeta decode(XdrDataInputStream stream) throws IOException {
        LedgerCloseMeta decodedLedgerCloseMeta = new LedgerCloseMeta();
        Integer discriminant = stream.readInt();
        decodedLedgerCloseMeta.setDiscriminant(discriminant);
        switch (decodedLedgerCloseMeta.getDiscriminant()) {
            case 0: {
                decodedLedgerCloseMeta.v0 = LedgerCloseMetaV0.decode(stream);
                break;
            }
            case 1: {
                decodedLedgerCloseMeta.v1 = LedgerCloseMetaV1.decode(stream);
            }
        }
        return decodedLedgerCloseMeta;
    }

    public int hashCode() {
        return Objects.hash(this.v0, this.v1, this.v);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LedgerCloseMeta)) {
            return false;
        }
        LedgerCloseMeta other = (LedgerCloseMeta)object;
        return Objects.equals(this.v0, other.v0) && Objects.equals(this.v1, other.v1) && Objects.equals(this.v, other.v);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static LedgerCloseMeta fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LedgerCloseMeta.fromXdrByteArray(bytes);
    }

    public static LedgerCloseMeta fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LedgerCloseMeta.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private Integer discriminant;
        private LedgerCloseMetaV0 v0;
        private LedgerCloseMetaV1 v1;

        public Builder discriminant(Integer discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder v0(LedgerCloseMetaV0 v0) {
            this.v0 = v0;
            return this;
        }

        public Builder v1(LedgerCloseMetaV1 v1) {
            this.v1 = v1;
            return this;
        }

        public LedgerCloseMeta build() {
            LedgerCloseMeta val = new LedgerCloseMeta();
            val.setDiscriminant(this.discriminant);
            val.setV0(this.v0);
            val.setV1(this.v1);
            return val;
        }
    }
}

