/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.ClaimableBalanceID;
import org.stellar.sdk.xdr.ConfigSettingID;
import org.stellar.sdk.xdr.ContractDataDurability;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.LedgerEntryType;
import org.stellar.sdk.xdr.PoolID;
import org.stellar.sdk.xdr.SCAddress;
import org.stellar.sdk.xdr.SCVal;
import org.stellar.sdk.xdr.String64;
import org.stellar.sdk.xdr.TrustLineAsset;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class LedgerKey
implements XdrElement {
    LedgerEntryType type;
    private LedgerKeyAccount account;
    private LedgerKeyTrustLine trustLine;
    private LedgerKeyOffer offer;
    private LedgerKeyData data;
    private LedgerKeyClaimableBalance claimableBalance;
    private LedgerKeyLiquidityPool liquidityPool;
    private LedgerKeyContractData contractData;
    private LedgerKeyContractCode contractCode;
    private LedgerKeyConfigSetting configSetting;
    private LedgerKeyTtl ttl;

    public LedgerEntryType getDiscriminant() {
        return this.type;
    }

    public void setDiscriminant(LedgerEntryType value) {
        this.type = value;
    }

    public LedgerKeyAccount getAccount() {
        return this.account;
    }

    public void setAccount(LedgerKeyAccount value) {
        this.account = value;
    }

    public LedgerKeyTrustLine getTrustLine() {
        return this.trustLine;
    }

    public void setTrustLine(LedgerKeyTrustLine value) {
        this.trustLine = value;
    }

    public LedgerKeyOffer getOffer() {
        return this.offer;
    }

    public void setOffer(LedgerKeyOffer value) {
        this.offer = value;
    }

    public LedgerKeyData getData() {
        return this.data;
    }

    public void setData(LedgerKeyData value) {
        this.data = value;
    }

    public LedgerKeyClaimableBalance getClaimableBalance() {
        return this.claimableBalance;
    }

    public void setClaimableBalance(LedgerKeyClaimableBalance value) {
        this.claimableBalance = value;
    }

    public LedgerKeyLiquidityPool getLiquidityPool() {
        return this.liquidityPool;
    }

    public void setLiquidityPool(LedgerKeyLiquidityPool value) {
        this.liquidityPool = value;
    }

    public LedgerKeyContractData getContractData() {
        return this.contractData;
    }

    public void setContractData(LedgerKeyContractData value) {
        this.contractData = value;
    }

    public LedgerKeyContractCode getContractCode() {
        return this.contractCode;
    }

    public void setContractCode(LedgerKeyContractCode value) {
        this.contractCode = value;
    }

    public LedgerKeyConfigSetting getConfigSetting() {
        return this.configSetting;
    }

    public void setConfigSetting(LedgerKeyConfigSetting value) {
        this.configSetting = value;
    }

    public LedgerKeyTtl getTtl() {
        return this.ttl;
    }

    public void setTtl(LedgerKeyTtl value) {
        this.ttl = value;
    }

    public static void encode(XdrDataOutputStream stream, LedgerKey encodedLedgerKey) throws IOException {
        stream.writeInt(encodedLedgerKey.getDiscriminant().getValue());
        switch (encodedLedgerKey.getDiscriminant()) {
            case ACCOUNT: {
                LedgerKeyAccount.encode(stream, encodedLedgerKey.account);
                break;
            }
            case TRUSTLINE: {
                LedgerKeyTrustLine.encode(stream, encodedLedgerKey.trustLine);
                break;
            }
            case OFFER: {
                LedgerKeyOffer.encode(stream, encodedLedgerKey.offer);
                break;
            }
            case DATA: {
                LedgerKeyData.encode(stream, encodedLedgerKey.data);
                break;
            }
            case CLAIMABLE_BALANCE: {
                LedgerKeyClaimableBalance.encode(stream, encodedLedgerKey.claimableBalance);
                break;
            }
            case LIQUIDITY_POOL: {
                LedgerKeyLiquidityPool.encode(stream, encodedLedgerKey.liquidityPool);
                break;
            }
            case CONTRACT_DATA: {
                LedgerKeyContractData.encode(stream, encodedLedgerKey.contractData);
                break;
            }
            case CONTRACT_CODE: {
                LedgerKeyContractCode.encode(stream, encodedLedgerKey.contractCode);
                break;
            }
            case CONFIG_SETTING: {
                LedgerKeyConfigSetting.encode(stream, encodedLedgerKey.configSetting);
                break;
            }
            case TTL: {
                LedgerKeyTtl.encode(stream, encodedLedgerKey.ttl);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        LedgerKey.encode(stream, this);
    }

    public static LedgerKey decode(XdrDataInputStream stream) throws IOException {
        LedgerKey decodedLedgerKey = new LedgerKey();
        LedgerEntryType discriminant = LedgerEntryType.decode(stream);
        decodedLedgerKey.setDiscriminant(discriminant);
        switch (decodedLedgerKey.getDiscriminant()) {
            case ACCOUNT: {
                decodedLedgerKey.account = LedgerKeyAccount.decode(stream);
                break;
            }
            case TRUSTLINE: {
                decodedLedgerKey.trustLine = LedgerKeyTrustLine.decode(stream);
                break;
            }
            case OFFER: {
                decodedLedgerKey.offer = LedgerKeyOffer.decode(stream);
                break;
            }
            case DATA: {
                decodedLedgerKey.data = LedgerKeyData.decode(stream);
                break;
            }
            case CLAIMABLE_BALANCE: {
                decodedLedgerKey.claimableBalance = LedgerKeyClaimableBalance.decode(stream);
                break;
            }
            case LIQUIDITY_POOL: {
                decodedLedgerKey.liquidityPool = LedgerKeyLiquidityPool.decode(stream);
                break;
            }
            case CONTRACT_DATA: {
                decodedLedgerKey.contractData = LedgerKeyContractData.decode(stream);
                break;
            }
            case CONTRACT_CODE: {
                decodedLedgerKey.contractCode = LedgerKeyContractCode.decode(stream);
                break;
            }
            case CONFIG_SETTING: {
                decodedLedgerKey.configSetting = LedgerKeyConfigSetting.decode(stream);
                break;
            }
            case TTL: {
                decodedLedgerKey.ttl = LedgerKeyTtl.decode(stream);
            }
        }
        return decodedLedgerKey;
    }

    public int hashCode() {
        return Objects.hash(this.account, this.trustLine, this.offer, this.data, this.claimableBalance, this.liquidityPool, this.contractData, this.contractCode, this.configSetting, this.ttl, this.type);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LedgerKey)) {
            return false;
        }
        LedgerKey other = (LedgerKey)object;
        return Objects.equals(this.account, other.account) && Objects.equals(this.trustLine, other.trustLine) && Objects.equals(this.offer, other.offer) && Objects.equals(this.data, other.data) && Objects.equals(this.claimableBalance, other.claimableBalance) && Objects.equals(this.liquidityPool, other.liquidityPool) && Objects.equals(this.contractData, other.contractData) && Objects.equals(this.contractCode, other.contractCode) && Objects.equals(this.configSetting, other.configSetting) && Objects.equals(this.ttl, other.ttl) && Objects.equals(this.type, other.type);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static LedgerKey fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LedgerKey.fromXdrByteArray(bytes);
    }

    public static LedgerKey fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LedgerKey.decode(xdrDataInputStream);
    }

    public static class LedgerKeyAccount
    implements XdrElement {
        private AccountID accountID;

        public AccountID getAccountID() {
            return this.accountID;
        }

        public void setAccountID(AccountID value) {
            this.accountID = value;
        }

        public static void encode(XdrDataOutputStream stream, LedgerKeyAccount encodedLedgerKeyAccount) throws IOException {
            AccountID.encode(stream, encodedLedgerKeyAccount.accountID);
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            LedgerKeyAccount.encode(stream, this);
        }

        public static LedgerKeyAccount decode(XdrDataInputStream stream) throws IOException {
            LedgerKeyAccount decodedLedgerKeyAccount = new LedgerKeyAccount();
            decodedLedgerKeyAccount.accountID = AccountID.decode(stream);
            return decodedLedgerKeyAccount;
        }

        public int hashCode() {
            return Objects.hash(this.accountID);
        }

        public boolean equals(Object object) {
            if (!(object instanceof LedgerKeyAccount)) {
                return false;
            }
            LedgerKeyAccount other = (LedgerKeyAccount)object;
            return Objects.equals(this.accountID, other.accountID);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static LedgerKeyAccount fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return LedgerKeyAccount.fromXdrByteArray(bytes);
        }

        public static LedgerKeyAccount fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return LedgerKeyAccount.decode(xdrDataInputStream);
        }

        public static final class Builder {
            private AccountID accountID;

            public Builder accountID(AccountID accountID) {
                this.accountID = accountID;
                return this;
            }

            public LedgerKeyAccount build() {
                LedgerKeyAccount val = new LedgerKeyAccount();
                val.setAccountID(this.accountID);
                return val;
            }
        }
    }

    public static class LedgerKeyTrustLine
    implements XdrElement {
        private AccountID accountID;
        private TrustLineAsset asset;

        public AccountID getAccountID() {
            return this.accountID;
        }

        public void setAccountID(AccountID value) {
            this.accountID = value;
        }

        public TrustLineAsset getAsset() {
            return this.asset;
        }

        public void setAsset(TrustLineAsset value) {
            this.asset = value;
        }

        public static void encode(XdrDataOutputStream stream, LedgerKeyTrustLine encodedLedgerKeyTrustLine) throws IOException {
            AccountID.encode(stream, encodedLedgerKeyTrustLine.accountID);
            TrustLineAsset.encode(stream, encodedLedgerKeyTrustLine.asset);
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            LedgerKeyTrustLine.encode(stream, this);
        }

        public static LedgerKeyTrustLine decode(XdrDataInputStream stream) throws IOException {
            LedgerKeyTrustLine decodedLedgerKeyTrustLine = new LedgerKeyTrustLine();
            decodedLedgerKeyTrustLine.accountID = AccountID.decode(stream);
            decodedLedgerKeyTrustLine.asset = TrustLineAsset.decode(stream);
            return decodedLedgerKeyTrustLine;
        }

        public int hashCode() {
            return Objects.hash(this.accountID, this.asset);
        }

        public boolean equals(Object object) {
            if (!(object instanceof LedgerKeyTrustLine)) {
                return false;
            }
            LedgerKeyTrustLine other = (LedgerKeyTrustLine)object;
            return Objects.equals(this.accountID, other.accountID) && Objects.equals(this.asset, other.asset);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static LedgerKeyTrustLine fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return LedgerKeyTrustLine.fromXdrByteArray(bytes);
        }

        public static LedgerKeyTrustLine fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return LedgerKeyTrustLine.decode(xdrDataInputStream);
        }

        public static final class Builder {
            private AccountID accountID;
            private TrustLineAsset asset;

            public Builder accountID(AccountID accountID) {
                this.accountID = accountID;
                return this;
            }

            public Builder asset(TrustLineAsset asset) {
                this.asset = asset;
                return this;
            }

            public LedgerKeyTrustLine build() {
                LedgerKeyTrustLine val = new LedgerKeyTrustLine();
                val.setAccountID(this.accountID);
                val.setAsset(this.asset);
                return val;
            }
        }
    }

    public static class LedgerKeyOffer
    implements XdrElement {
        private AccountID sellerID;
        private Int64 offerID;

        public AccountID getSellerID() {
            return this.sellerID;
        }

        public void setSellerID(AccountID value) {
            this.sellerID = value;
        }

        public Int64 getOfferID() {
            return this.offerID;
        }

        public void setOfferID(Int64 value) {
            this.offerID = value;
        }

        public static void encode(XdrDataOutputStream stream, LedgerKeyOffer encodedLedgerKeyOffer) throws IOException {
            AccountID.encode(stream, encodedLedgerKeyOffer.sellerID);
            Int64.encode(stream, encodedLedgerKeyOffer.offerID);
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            LedgerKeyOffer.encode(stream, this);
        }

        public static LedgerKeyOffer decode(XdrDataInputStream stream) throws IOException {
            LedgerKeyOffer decodedLedgerKeyOffer = new LedgerKeyOffer();
            decodedLedgerKeyOffer.sellerID = AccountID.decode(stream);
            decodedLedgerKeyOffer.offerID = Int64.decode(stream);
            return decodedLedgerKeyOffer;
        }

        public int hashCode() {
            return Objects.hash(this.sellerID, this.offerID);
        }

        public boolean equals(Object object) {
            if (!(object instanceof LedgerKeyOffer)) {
                return false;
            }
            LedgerKeyOffer other = (LedgerKeyOffer)object;
            return Objects.equals(this.sellerID, other.sellerID) && Objects.equals(this.offerID, other.offerID);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static LedgerKeyOffer fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return LedgerKeyOffer.fromXdrByteArray(bytes);
        }

        public static LedgerKeyOffer fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return LedgerKeyOffer.decode(xdrDataInputStream);
        }

        public static final class Builder {
            private AccountID sellerID;
            private Int64 offerID;

            public Builder sellerID(AccountID sellerID) {
                this.sellerID = sellerID;
                return this;
            }

            public Builder offerID(Int64 offerID) {
                this.offerID = offerID;
                return this;
            }

            public LedgerKeyOffer build() {
                LedgerKeyOffer val = new LedgerKeyOffer();
                val.setSellerID(this.sellerID);
                val.setOfferID(this.offerID);
                return val;
            }
        }
    }

    public static class LedgerKeyData
    implements XdrElement {
        private AccountID accountID;
        private String64 dataName;

        public AccountID getAccountID() {
            return this.accountID;
        }

        public void setAccountID(AccountID value) {
            this.accountID = value;
        }

        public String64 getDataName() {
            return this.dataName;
        }

        public void setDataName(String64 value) {
            this.dataName = value;
        }

        public static void encode(XdrDataOutputStream stream, LedgerKeyData encodedLedgerKeyData) throws IOException {
            AccountID.encode(stream, encodedLedgerKeyData.accountID);
            String64.encode(stream, encodedLedgerKeyData.dataName);
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            LedgerKeyData.encode(stream, this);
        }

        public static LedgerKeyData decode(XdrDataInputStream stream) throws IOException {
            LedgerKeyData decodedLedgerKeyData = new LedgerKeyData();
            decodedLedgerKeyData.accountID = AccountID.decode(stream);
            decodedLedgerKeyData.dataName = String64.decode(stream);
            return decodedLedgerKeyData;
        }

        public int hashCode() {
            return Objects.hash(this.accountID, this.dataName);
        }

        public boolean equals(Object object) {
            if (!(object instanceof LedgerKeyData)) {
                return false;
            }
            LedgerKeyData other = (LedgerKeyData)object;
            return Objects.equals(this.accountID, other.accountID) && Objects.equals(this.dataName, other.dataName);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static LedgerKeyData fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return LedgerKeyData.fromXdrByteArray(bytes);
        }

        public static LedgerKeyData fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return LedgerKeyData.decode(xdrDataInputStream);
        }

        public static final class Builder {
            private AccountID accountID;
            private String64 dataName;

            public Builder accountID(AccountID accountID) {
                this.accountID = accountID;
                return this;
            }

            public Builder dataName(String64 dataName) {
                this.dataName = dataName;
                return this;
            }

            public LedgerKeyData build() {
                LedgerKeyData val = new LedgerKeyData();
                val.setAccountID(this.accountID);
                val.setDataName(this.dataName);
                return val;
            }
        }
    }

    public static class LedgerKeyClaimableBalance
    implements XdrElement {
        private ClaimableBalanceID balanceID;

        public ClaimableBalanceID getBalanceID() {
            return this.balanceID;
        }

        public void setBalanceID(ClaimableBalanceID value) {
            this.balanceID = value;
        }

        public static void encode(XdrDataOutputStream stream, LedgerKeyClaimableBalance encodedLedgerKeyClaimableBalance) throws IOException {
            ClaimableBalanceID.encode(stream, encodedLedgerKeyClaimableBalance.balanceID);
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            LedgerKeyClaimableBalance.encode(stream, this);
        }

        public static LedgerKeyClaimableBalance decode(XdrDataInputStream stream) throws IOException {
            LedgerKeyClaimableBalance decodedLedgerKeyClaimableBalance = new LedgerKeyClaimableBalance();
            decodedLedgerKeyClaimableBalance.balanceID = ClaimableBalanceID.decode(stream);
            return decodedLedgerKeyClaimableBalance;
        }

        public int hashCode() {
            return Objects.hash(this.balanceID);
        }

        public boolean equals(Object object) {
            if (!(object instanceof LedgerKeyClaimableBalance)) {
                return false;
            }
            LedgerKeyClaimableBalance other = (LedgerKeyClaimableBalance)object;
            return Objects.equals(this.balanceID, other.balanceID);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static LedgerKeyClaimableBalance fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return LedgerKeyClaimableBalance.fromXdrByteArray(bytes);
        }

        public static LedgerKeyClaimableBalance fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return LedgerKeyClaimableBalance.decode(xdrDataInputStream);
        }

        public static final class Builder {
            private ClaimableBalanceID balanceID;

            public Builder balanceID(ClaimableBalanceID balanceID) {
                this.balanceID = balanceID;
                return this;
            }

            public LedgerKeyClaimableBalance build() {
                LedgerKeyClaimableBalance val = new LedgerKeyClaimableBalance();
                val.setBalanceID(this.balanceID);
                return val;
            }
        }
    }

    public static class LedgerKeyLiquidityPool
    implements XdrElement {
        private PoolID liquidityPoolID;

        public PoolID getLiquidityPoolID() {
            return this.liquidityPoolID;
        }

        public void setLiquidityPoolID(PoolID value) {
            this.liquidityPoolID = value;
        }

        public static void encode(XdrDataOutputStream stream, LedgerKeyLiquidityPool encodedLedgerKeyLiquidityPool) throws IOException {
            PoolID.encode(stream, encodedLedgerKeyLiquidityPool.liquidityPoolID);
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            LedgerKeyLiquidityPool.encode(stream, this);
        }

        public static LedgerKeyLiquidityPool decode(XdrDataInputStream stream) throws IOException {
            LedgerKeyLiquidityPool decodedLedgerKeyLiquidityPool = new LedgerKeyLiquidityPool();
            decodedLedgerKeyLiquidityPool.liquidityPoolID = PoolID.decode(stream);
            return decodedLedgerKeyLiquidityPool;
        }

        public int hashCode() {
            return Objects.hash(this.liquidityPoolID);
        }

        public boolean equals(Object object) {
            if (!(object instanceof LedgerKeyLiquidityPool)) {
                return false;
            }
            LedgerKeyLiquidityPool other = (LedgerKeyLiquidityPool)object;
            return Objects.equals(this.liquidityPoolID, other.liquidityPoolID);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static LedgerKeyLiquidityPool fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return LedgerKeyLiquidityPool.fromXdrByteArray(bytes);
        }

        public static LedgerKeyLiquidityPool fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return LedgerKeyLiquidityPool.decode(xdrDataInputStream);
        }

        public static final class Builder {
            private PoolID liquidityPoolID;

            public Builder liquidityPoolID(PoolID liquidityPoolID) {
                this.liquidityPoolID = liquidityPoolID;
                return this;
            }

            public LedgerKeyLiquidityPool build() {
                LedgerKeyLiquidityPool val = new LedgerKeyLiquidityPool();
                val.setLiquidityPoolID(this.liquidityPoolID);
                return val;
            }
        }
    }

    public static class LedgerKeyContractData
    implements XdrElement {
        private SCAddress contract;
        private SCVal key;
        private ContractDataDurability durability;

        public SCAddress getContract() {
            return this.contract;
        }

        public void setContract(SCAddress value) {
            this.contract = value;
        }

        public SCVal getKey() {
            return this.key;
        }

        public void setKey(SCVal value) {
            this.key = value;
        }

        public ContractDataDurability getDurability() {
            return this.durability;
        }

        public void setDurability(ContractDataDurability value) {
            this.durability = value;
        }

        public static void encode(XdrDataOutputStream stream, LedgerKeyContractData encodedLedgerKeyContractData) throws IOException {
            SCAddress.encode(stream, encodedLedgerKeyContractData.contract);
            SCVal.encode(stream, encodedLedgerKeyContractData.key);
            ContractDataDurability.encode(stream, encodedLedgerKeyContractData.durability);
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            LedgerKeyContractData.encode(stream, this);
        }

        public static LedgerKeyContractData decode(XdrDataInputStream stream) throws IOException {
            LedgerKeyContractData decodedLedgerKeyContractData = new LedgerKeyContractData();
            decodedLedgerKeyContractData.contract = SCAddress.decode(stream);
            decodedLedgerKeyContractData.key = SCVal.decode(stream);
            decodedLedgerKeyContractData.durability = ContractDataDurability.decode(stream);
            return decodedLedgerKeyContractData;
        }

        public int hashCode() {
            return Objects.hash(this.contract, this.key, this.durability);
        }

        public boolean equals(Object object) {
            if (!(object instanceof LedgerKeyContractData)) {
                return false;
            }
            LedgerKeyContractData other = (LedgerKeyContractData)object;
            return Objects.equals(this.contract, other.contract) && Objects.equals(this.key, other.key) && Objects.equals(this.durability, other.durability);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static LedgerKeyContractData fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return LedgerKeyContractData.fromXdrByteArray(bytes);
        }

        public static LedgerKeyContractData fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return LedgerKeyContractData.decode(xdrDataInputStream);
        }

        public static final class Builder {
            private SCAddress contract;
            private SCVal key;
            private ContractDataDurability durability;

            public Builder contract(SCAddress contract) {
                this.contract = contract;
                return this;
            }

            public Builder key(SCVal key) {
                this.key = key;
                return this;
            }

            public Builder durability(ContractDataDurability durability) {
                this.durability = durability;
                return this;
            }

            public LedgerKeyContractData build() {
                LedgerKeyContractData val = new LedgerKeyContractData();
                val.setContract(this.contract);
                val.setKey(this.key);
                val.setDurability(this.durability);
                return val;
            }
        }
    }

    public static class LedgerKeyContractCode
    implements XdrElement {
        private Hash hash;

        public Hash getHash() {
            return this.hash;
        }

        public void setHash(Hash value) {
            this.hash = value;
        }

        public static void encode(XdrDataOutputStream stream, LedgerKeyContractCode encodedLedgerKeyContractCode) throws IOException {
            Hash.encode(stream, encodedLedgerKeyContractCode.hash);
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            LedgerKeyContractCode.encode(stream, this);
        }

        public static LedgerKeyContractCode decode(XdrDataInputStream stream) throws IOException {
            LedgerKeyContractCode decodedLedgerKeyContractCode = new LedgerKeyContractCode();
            decodedLedgerKeyContractCode.hash = Hash.decode(stream);
            return decodedLedgerKeyContractCode;
        }

        public int hashCode() {
            return Objects.hash(this.hash);
        }

        public boolean equals(Object object) {
            if (!(object instanceof LedgerKeyContractCode)) {
                return false;
            }
            LedgerKeyContractCode other = (LedgerKeyContractCode)object;
            return Objects.equals(this.hash, other.hash);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static LedgerKeyContractCode fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return LedgerKeyContractCode.fromXdrByteArray(bytes);
        }

        public static LedgerKeyContractCode fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return LedgerKeyContractCode.decode(xdrDataInputStream);
        }

        public static final class Builder {
            private Hash hash;

            public Builder hash(Hash hash) {
                this.hash = hash;
                return this;
            }

            public LedgerKeyContractCode build() {
                LedgerKeyContractCode val = new LedgerKeyContractCode();
                val.setHash(this.hash);
                return val;
            }
        }
    }

    public static class LedgerKeyConfigSetting
    implements XdrElement {
        private ConfigSettingID configSettingID;

        public ConfigSettingID getConfigSettingID() {
            return this.configSettingID;
        }

        public void setConfigSettingID(ConfigSettingID value) {
            this.configSettingID = value;
        }

        public static void encode(XdrDataOutputStream stream, LedgerKeyConfigSetting encodedLedgerKeyConfigSetting) throws IOException {
            ConfigSettingID.encode(stream, encodedLedgerKeyConfigSetting.configSettingID);
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            LedgerKeyConfigSetting.encode(stream, this);
        }

        public static LedgerKeyConfigSetting decode(XdrDataInputStream stream) throws IOException {
            LedgerKeyConfigSetting decodedLedgerKeyConfigSetting = new LedgerKeyConfigSetting();
            decodedLedgerKeyConfigSetting.configSettingID = ConfigSettingID.decode(stream);
            return decodedLedgerKeyConfigSetting;
        }

        public int hashCode() {
            return Objects.hash(this.configSettingID);
        }

        public boolean equals(Object object) {
            if (!(object instanceof LedgerKeyConfigSetting)) {
                return false;
            }
            LedgerKeyConfigSetting other = (LedgerKeyConfigSetting)object;
            return Objects.equals(this.configSettingID, other.configSettingID);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static LedgerKeyConfigSetting fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return LedgerKeyConfigSetting.fromXdrByteArray(bytes);
        }

        public static LedgerKeyConfigSetting fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return LedgerKeyConfigSetting.decode(xdrDataInputStream);
        }

        public static final class Builder {
            private ConfigSettingID configSettingID;

            public Builder configSettingID(ConfigSettingID configSettingID) {
                this.configSettingID = configSettingID;
                return this;
            }

            public LedgerKeyConfigSetting build() {
                LedgerKeyConfigSetting val = new LedgerKeyConfigSetting();
                val.setConfigSettingID(this.configSettingID);
                return val;
            }
        }
    }

    public static class LedgerKeyTtl
    implements XdrElement {
        private Hash keyHash;

        public Hash getKeyHash() {
            return this.keyHash;
        }

        public void setKeyHash(Hash value) {
            this.keyHash = value;
        }

        public static void encode(XdrDataOutputStream stream, LedgerKeyTtl encodedLedgerKeyTtl) throws IOException {
            Hash.encode(stream, encodedLedgerKeyTtl.keyHash);
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            LedgerKeyTtl.encode(stream, this);
        }

        public static LedgerKeyTtl decode(XdrDataInputStream stream) throws IOException {
            LedgerKeyTtl decodedLedgerKeyTtl = new LedgerKeyTtl();
            decodedLedgerKeyTtl.keyHash = Hash.decode(stream);
            return decodedLedgerKeyTtl;
        }

        public int hashCode() {
            return Objects.hash(this.keyHash);
        }

        public boolean equals(Object object) {
            if (!(object instanceof LedgerKeyTtl)) {
                return false;
            }
            LedgerKeyTtl other = (LedgerKeyTtl)object;
            return Objects.equals(this.keyHash, other.keyHash);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static LedgerKeyTtl fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return LedgerKeyTtl.fromXdrByteArray(bytes);
        }

        public static LedgerKeyTtl fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return LedgerKeyTtl.decode(xdrDataInputStream);
        }

        public static final class Builder {
            private Hash keyHash;

            public Builder keyHash(Hash keyHash) {
                this.keyHash = keyHash;
                return this;
            }

            public LedgerKeyTtl build() {
                LedgerKeyTtl val = new LedgerKeyTtl();
                val.setKeyHash(this.keyHash);
                return val;
            }
        }
    }

    public static final class Builder {
        private LedgerEntryType discriminant;
        private LedgerKeyAccount account;
        private LedgerKeyTrustLine trustLine;
        private LedgerKeyOffer offer;
        private LedgerKeyData data;
        private LedgerKeyClaimableBalance claimableBalance;
        private LedgerKeyLiquidityPool liquidityPool;
        private LedgerKeyContractData contractData;
        private LedgerKeyContractCode contractCode;
        private LedgerKeyConfigSetting configSetting;
        private LedgerKeyTtl ttl;

        public Builder discriminant(LedgerEntryType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder account(LedgerKeyAccount account) {
            this.account = account;
            return this;
        }

        public Builder trustLine(LedgerKeyTrustLine trustLine) {
            this.trustLine = trustLine;
            return this;
        }

        public Builder offer(LedgerKeyOffer offer) {
            this.offer = offer;
            return this;
        }

        public Builder data(LedgerKeyData data) {
            this.data = data;
            return this;
        }

        public Builder claimableBalance(LedgerKeyClaimableBalance claimableBalance) {
            this.claimableBalance = claimableBalance;
            return this;
        }

        public Builder liquidityPool(LedgerKeyLiquidityPool liquidityPool) {
            this.liquidityPool = liquidityPool;
            return this;
        }

        public Builder contractData(LedgerKeyContractData contractData) {
            this.contractData = contractData;
            return this;
        }

        public Builder contractCode(LedgerKeyContractCode contractCode) {
            this.contractCode = contractCode;
            return this;
        }

        public Builder configSetting(LedgerKeyConfigSetting configSetting) {
            this.configSetting = configSetting;
            return this;
        }

        public Builder ttl(LedgerKeyTtl ttl) {
            this.ttl = ttl;
            return this;
        }

        public LedgerKey build() {
            LedgerKey val = new LedgerKey();
            val.setDiscriminant(this.discriminant);
            val.setAccount(this.account);
            val.setTrustLine(this.trustLine);
            val.setOffer(this.offer);
            val.setData(this.data);
            val.setClaimableBalance(this.claimableBalance);
            val.setLiquidityPool(this.liquidityPool);
            val.setContractData(this.contractData);
            val.setContractCode(this.contractCode);
            val.setConfigSetting(this.configSetting);
            val.setTtl(this.ttl);
            return val;
        }
    }
}

