/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Price;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ManageBuyOfferOp
implements XdrElement {
    private Asset selling;
    private Asset buying;
    private Int64 buyAmount;
    private Price price;
    private Int64 offerID;

    public Asset getSelling() {
        return this.selling;
    }

    public void setSelling(Asset value) {
        this.selling = value;
    }

    public Asset getBuying() {
        return this.buying;
    }

    public void setBuying(Asset value) {
        this.buying = value;
    }

    public Int64 getBuyAmount() {
        return this.buyAmount;
    }

    public void setBuyAmount(Int64 value) {
        this.buyAmount = value;
    }

    public Price getPrice() {
        return this.price;
    }

    public void setPrice(Price value) {
        this.price = value;
    }

    public Int64 getOfferID() {
        return this.offerID;
    }

    public void setOfferID(Int64 value) {
        this.offerID = value;
    }

    public static void encode(XdrDataOutputStream stream, ManageBuyOfferOp encodedManageBuyOfferOp) throws IOException {
        Asset.encode(stream, encodedManageBuyOfferOp.selling);
        Asset.encode(stream, encodedManageBuyOfferOp.buying);
        Int64.encode(stream, encodedManageBuyOfferOp.buyAmount);
        Price.encode(stream, encodedManageBuyOfferOp.price);
        Int64.encode(stream, encodedManageBuyOfferOp.offerID);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        ManageBuyOfferOp.encode(stream, this);
    }

    public static ManageBuyOfferOp decode(XdrDataInputStream stream) throws IOException {
        ManageBuyOfferOp decodedManageBuyOfferOp = new ManageBuyOfferOp();
        decodedManageBuyOfferOp.selling = Asset.decode(stream);
        decodedManageBuyOfferOp.buying = Asset.decode(stream);
        decodedManageBuyOfferOp.buyAmount = Int64.decode(stream);
        decodedManageBuyOfferOp.price = Price.decode(stream);
        decodedManageBuyOfferOp.offerID = Int64.decode(stream);
        return decodedManageBuyOfferOp;
    }

    public int hashCode() {
        return Objects.hash(this.selling, this.buying, this.buyAmount, this.price, this.offerID);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ManageBuyOfferOp)) {
            return false;
        }
        ManageBuyOfferOp other = (ManageBuyOfferOp)object;
        return Objects.equals(this.selling, other.selling) && Objects.equals(this.buying, other.buying) && Objects.equals(this.buyAmount, other.buyAmount) && Objects.equals(this.price, other.price) && Objects.equals(this.offerID, other.offerID);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static ManageBuyOfferOp fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ManageBuyOfferOp.fromXdrByteArray(bytes);
    }

    public static ManageBuyOfferOp fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ManageBuyOfferOp.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private Asset selling;
        private Asset buying;
        private Int64 buyAmount;
        private Price price;
        private Int64 offerID;

        public Builder selling(Asset selling) {
            this.selling = selling;
            return this;
        }

        public Builder buying(Asset buying) {
            this.buying = buying;
            return this;
        }

        public Builder buyAmount(Int64 buyAmount) {
            this.buyAmount = buyAmount;
            return this;
        }

        public Builder price(Price price) {
            this.price = price;
            return this;
        }

        public Builder offerID(Int64 offerID) {
            this.offerID = offerID;
            return this;
        }

        public ManageBuyOfferOp build() {
            ManageBuyOfferOp val = new ManageBuyOfferOp();
            val.setSelling(this.selling);
            val.setBuying(this.buying);
            val.setBuyAmount(this.buyAmount);
            val.setPrice(this.price);
            val.setOfferID(this.offerID);
            return val;
        }
    }
}

