/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.MuxedAccount;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class PathPaymentStrictReceiveOp
implements XdrElement {
    private Asset sendAsset;
    private Int64 sendMax;
    private MuxedAccount destination;
    private Asset destAsset;
    private Int64 destAmount;
    private Asset[] path;

    public Asset getSendAsset() {
        return this.sendAsset;
    }

    public void setSendAsset(Asset value) {
        this.sendAsset = value;
    }

    public Int64 getSendMax() {
        return this.sendMax;
    }

    public void setSendMax(Int64 value) {
        this.sendMax = value;
    }

    public MuxedAccount getDestination() {
        return this.destination;
    }

    public void setDestination(MuxedAccount value) {
        this.destination = value;
    }

    public Asset getDestAsset() {
        return this.destAsset;
    }

    public void setDestAsset(Asset value) {
        this.destAsset = value;
    }

    public Int64 getDestAmount() {
        return this.destAmount;
    }

    public void setDestAmount(Int64 value) {
        this.destAmount = value;
    }

    public Asset[] getPath() {
        return this.path;
    }

    public void setPath(Asset[] value) {
        this.path = value;
    }

    public static void encode(XdrDataOutputStream stream, PathPaymentStrictReceiveOp encodedPathPaymentStrictReceiveOp) throws IOException {
        Asset.encode(stream, encodedPathPaymentStrictReceiveOp.sendAsset);
        Int64.encode(stream, encodedPathPaymentStrictReceiveOp.sendMax);
        MuxedAccount.encode(stream, encodedPathPaymentStrictReceiveOp.destination);
        Asset.encode(stream, encodedPathPaymentStrictReceiveOp.destAsset);
        Int64.encode(stream, encodedPathPaymentStrictReceiveOp.destAmount);
        int pathsize = encodedPathPaymentStrictReceiveOp.getPath().length;
        stream.writeInt(pathsize);
        for (int i = 0; i < pathsize; ++i) {
            Asset.encode(stream, encodedPathPaymentStrictReceiveOp.path[i]);
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        PathPaymentStrictReceiveOp.encode(stream, this);
    }

    public static PathPaymentStrictReceiveOp decode(XdrDataInputStream stream) throws IOException {
        PathPaymentStrictReceiveOp decodedPathPaymentStrictReceiveOp = new PathPaymentStrictReceiveOp();
        decodedPathPaymentStrictReceiveOp.sendAsset = Asset.decode(stream);
        decodedPathPaymentStrictReceiveOp.sendMax = Int64.decode(stream);
        decodedPathPaymentStrictReceiveOp.destination = MuxedAccount.decode(stream);
        decodedPathPaymentStrictReceiveOp.destAsset = Asset.decode(stream);
        decodedPathPaymentStrictReceiveOp.destAmount = Int64.decode(stream);
        int pathsize = stream.readInt();
        decodedPathPaymentStrictReceiveOp.path = new Asset[pathsize];
        for (int i = 0; i < pathsize; ++i) {
            decodedPathPaymentStrictReceiveOp.path[i] = Asset.decode(stream);
        }
        return decodedPathPaymentStrictReceiveOp;
    }

    public int hashCode() {
        return Objects.hash(this.sendAsset, this.sendMax, this.destination, this.destAsset, this.destAmount, Arrays.hashCode(this.path));
    }

    public boolean equals(Object object) {
        if (!(object instanceof PathPaymentStrictReceiveOp)) {
            return false;
        }
        PathPaymentStrictReceiveOp other = (PathPaymentStrictReceiveOp)object;
        return Objects.equals(this.sendAsset, other.sendAsset) && Objects.equals(this.sendMax, other.sendMax) && Objects.equals(this.destination, other.destination) && Objects.equals(this.destAsset, other.destAsset) && Objects.equals(this.destAmount, other.destAmount) && Arrays.equals(this.path, other.path);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static PathPaymentStrictReceiveOp fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return PathPaymentStrictReceiveOp.fromXdrByteArray(bytes);
    }

    public static PathPaymentStrictReceiveOp fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return PathPaymentStrictReceiveOp.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private Asset sendAsset;
        private Int64 sendMax;
        private MuxedAccount destination;
        private Asset destAsset;
        private Int64 destAmount;
        private Asset[] path;

        public Builder sendAsset(Asset sendAsset) {
            this.sendAsset = sendAsset;
            return this;
        }

        public Builder sendMax(Int64 sendMax) {
            this.sendMax = sendMax;
            return this;
        }

        public Builder destination(MuxedAccount destination) {
            this.destination = destination;
            return this;
        }

        public Builder destAsset(Asset destAsset) {
            this.destAsset = destAsset;
            return this;
        }

        public Builder destAmount(Int64 destAmount) {
            this.destAmount = destAmount;
            return this;
        }

        public Builder path(Asset[] path) {
            this.path = path;
            return this;
        }

        public PathPaymentStrictReceiveOp build() {
            PathPaymentStrictReceiveOp val = new PathPaymentStrictReceiveOp();
            val.setSendAsset(this.sendAsset);
            val.setSendMax(this.sendMax);
            val.setDestination(this.destination);
            val.setDestAsset(this.destAsset);
            val.setDestAmount(this.destAmount);
            val.setPath(this.path);
            return val;
        }
    }
}

