/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import org.stellar.sdk.xdr.XdrString;

public class SCMetaV0
implements XdrElement {
    private XdrString key;
    private XdrString val;

    public XdrString getKey() {
        return this.key;
    }

    public void setKey(XdrString value) {
        this.key = value;
    }

    public XdrString getVal() {
        return this.val;
    }

    public void setVal(XdrString value) {
        this.val = value;
    }

    public static void encode(XdrDataOutputStream stream, SCMetaV0 encodedSCMetaV0) throws IOException {
        encodedSCMetaV0.key.encode(stream);
        encodedSCMetaV0.val.encode(stream);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SCMetaV0.encode(stream, this);
    }

    public static SCMetaV0 decode(XdrDataInputStream stream) throws IOException {
        SCMetaV0 decodedSCMetaV0 = new SCMetaV0();
        decodedSCMetaV0.key = XdrString.decode(stream, Integer.MAX_VALUE);
        decodedSCMetaV0.val = XdrString.decode(stream, Integer.MAX_VALUE);
        return decodedSCMetaV0;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.val);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SCMetaV0)) {
            return false;
        }
        SCMetaV0 other = (SCMetaV0)object;
        return Objects.equals(this.key, other.key) && Objects.equals(this.val, other.val);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SCMetaV0 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCMetaV0.fromXdrByteArray(bytes);
    }

    public static SCMetaV0 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCMetaV0.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private XdrString key;
        private XdrString val;

        public Builder key(XdrString key) {
            this.key = key;
            return this;
        }

        public Builder val(XdrString val) {
            this.val = val;
            return this;
        }

        public SCMetaV0 build() {
            SCMetaV0 val = new SCMetaV0();
            val.setKey(this.key);
            val.setVal(this.val);
            return val;
        }
    }
}

