/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.EncryptedBody;
import org.stellar.sdk.xdr.NodeID;
import org.stellar.sdk.xdr.SurveyMessageCommandType;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SurveyResponseMessage
implements XdrElement {
    private NodeID surveyorPeerID;
    private NodeID surveyedPeerID;
    private Uint32 ledgerNum;
    private SurveyMessageCommandType commandType;
    private EncryptedBody encryptedBody;

    public NodeID getSurveyorPeerID() {
        return this.surveyorPeerID;
    }

    public void setSurveyorPeerID(NodeID value) {
        this.surveyorPeerID = value;
    }

    public NodeID getSurveyedPeerID() {
        return this.surveyedPeerID;
    }

    public void setSurveyedPeerID(NodeID value) {
        this.surveyedPeerID = value;
    }

    public Uint32 getLedgerNum() {
        return this.ledgerNum;
    }

    public void setLedgerNum(Uint32 value) {
        this.ledgerNum = value;
    }

    public SurveyMessageCommandType getCommandType() {
        return this.commandType;
    }

    public void setCommandType(SurveyMessageCommandType value) {
        this.commandType = value;
    }

    public EncryptedBody getEncryptedBody() {
        return this.encryptedBody;
    }

    public void setEncryptedBody(EncryptedBody value) {
        this.encryptedBody = value;
    }

    public static void encode(XdrDataOutputStream stream, SurveyResponseMessage encodedSurveyResponseMessage) throws IOException {
        NodeID.encode(stream, encodedSurveyResponseMessage.surveyorPeerID);
        NodeID.encode(stream, encodedSurveyResponseMessage.surveyedPeerID);
        Uint32.encode(stream, encodedSurveyResponseMessage.ledgerNum);
        SurveyMessageCommandType.encode(stream, encodedSurveyResponseMessage.commandType);
        EncryptedBody.encode(stream, encodedSurveyResponseMessage.encryptedBody);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SurveyResponseMessage.encode(stream, this);
    }

    public static SurveyResponseMessage decode(XdrDataInputStream stream) throws IOException {
        SurveyResponseMessage decodedSurveyResponseMessage = new SurveyResponseMessage();
        decodedSurveyResponseMessage.surveyorPeerID = NodeID.decode(stream);
        decodedSurveyResponseMessage.surveyedPeerID = NodeID.decode(stream);
        decodedSurveyResponseMessage.ledgerNum = Uint32.decode(stream);
        decodedSurveyResponseMessage.commandType = SurveyMessageCommandType.decode(stream);
        decodedSurveyResponseMessage.encryptedBody = EncryptedBody.decode(stream);
        return decodedSurveyResponseMessage;
    }

    public int hashCode() {
        return Objects.hash(this.surveyorPeerID, this.surveyedPeerID, this.ledgerNum, this.commandType, this.encryptedBody);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SurveyResponseMessage)) {
            return false;
        }
        SurveyResponseMessage other = (SurveyResponseMessage)object;
        return Objects.equals(this.surveyorPeerID, other.surveyorPeerID) && Objects.equals(this.surveyedPeerID, other.surveyedPeerID) && Objects.equals(this.ledgerNum, other.ledgerNum) && Objects.equals(this.commandType, other.commandType) && Objects.equals(this.encryptedBody, other.encryptedBody);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SurveyResponseMessage fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SurveyResponseMessage.fromXdrByteArray(bytes);
    }

    public static SurveyResponseMessage fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SurveyResponseMessage.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private NodeID surveyorPeerID;
        private NodeID surveyedPeerID;
        private Uint32 ledgerNum;
        private SurveyMessageCommandType commandType;
        private EncryptedBody encryptedBody;

        public Builder surveyorPeerID(NodeID surveyorPeerID) {
            this.surveyorPeerID = surveyorPeerID;
            return this;
        }

        public Builder surveyedPeerID(NodeID surveyedPeerID) {
            this.surveyedPeerID = surveyedPeerID;
            return this;
        }

        public Builder ledgerNum(Uint32 ledgerNum) {
            this.ledgerNum = ledgerNum;
            return this;
        }

        public Builder commandType(SurveyMessageCommandType commandType) {
            this.commandType = commandType;
            return this;
        }

        public Builder encryptedBody(EncryptedBody encryptedBody) {
            this.encryptedBody = encryptedBody;
            return this;
        }

        public SurveyResponseMessage build() {
            SurveyResponseMessage val = new SurveyResponseMessage();
            val.setSurveyorPeerID(this.surveyorPeerID);
            val.setSurveyedPeerID(this.surveyedPeerID);
            val.setLedgerNum(this.ledgerNum);
            val.setCommandType(this.commandType);
            val.setEncryptedBody(this.encryptedBody);
            return val;
        }
    }
}

