/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.TxSetComponent;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TransactionPhase
implements XdrElement {
    Integer v;
    private TxSetComponent[] v0Components;

    public Integer getDiscriminant() {
        return this.v;
    }

    public void setDiscriminant(Integer value) {
        this.v = value;
    }

    public TxSetComponent[] getV0Components() {
        return this.v0Components;
    }

    public void setV0Components(TxSetComponent[] value) {
        this.v0Components = value;
    }

    public static void encode(XdrDataOutputStream stream, TransactionPhase encodedTransactionPhase) throws IOException {
        stream.writeInt(encodedTransactionPhase.getDiscriminant());
        switch (encodedTransactionPhase.getDiscriminant()) {
            case 0: {
                int v0Componentssize = encodedTransactionPhase.getV0Components().length;
                stream.writeInt(v0Componentssize);
                for (int i = 0; i < v0Componentssize; ++i) {
                    TxSetComponent.encode(stream, encodedTransactionPhase.v0Components[i]);
                }
                break;
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        TransactionPhase.encode(stream, this);
    }

    public static TransactionPhase decode(XdrDataInputStream stream) throws IOException {
        TransactionPhase decodedTransactionPhase = new TransactionPhase();
        Integer discriminant = stream.readInt();
        decodedTransactionPhase.setDiscriminant(discriminant);
        switch (decodedTransactionPhase.getDiscriminant()) {
            case 0: {
                int v0Componentssize = stream.readInt();
                decodedTransactionPhase.v0Components = new TxSetComponent[v0Componentssize];
                for (int i = 0; i < v0Componentssize; ++i) {
                    decodedTransactionPhase.v0Components[i] = TxSetComponent.decode(stream);
                }
                break;
            }
        }
        return decodedTransactionPhase;
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.v0Components), this.v);
    }

    public boolean equals(Object object) {
        if (!(object instanceof TransactionPhase)) {
            return false;
        }
        TransactionPhase other = (TransactionPhase)object;
        return Arrays.equals(this.v0Components, other.v0Components) && Objects.equals(this.v, other.v);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static TransactionPhase fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TransactionPhase.fromXdrByteArray(bytes);
    }

    public static TransactionPhase fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TransactionPhase.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private Integer discriminant;
        private TxSetComponent[] v0Components;

        public Builder discriminant(Integer discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder v0Components(TxSetComponent[] v0Components) {
            this.v0Components = v0Components;
            return this;
        }

        public TransactionPhase build() {
            TransactionPhase val = new TransactionPhase();
            val.setDiscriminant(this.discriminant);
            val.setV0Components(this.v0Components);
            return val;
        }
    }
}

