/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.DecoratedSignature;
import org.stellar.sdk.xdr.Transaction;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TransactionV1Envelope
implements XdrElement {
    private Transaction tx;
    private DecoratedSignature[] signatures;

    public Transaction getTx() {
        return this.tx;
    }

    public void setTx(Transaction value) {
        this.tx = value;
    }

    public DecoratedSignature[] getSignatures() {
        return this.signatures;
    }

    public void setSignatures(DecoratedSignature[] value) {
        this.signatures = value;
    }

    public static void encode(XdrDataOutputStream stream, TransactionV1Envelope encodedTransactionV1Envelope) throws IOException {
        Transaction.encode(stream, encodedTransactionV1Envelope.tx);
        int signaturessize = encodedTransactionV1Envelope.getSignatures().length;
        stream.writeInt(signaturessize);
        for (int i = 0; i < signaturessize; ++i) {
            DecoratedSignature.encode(stream, encodedTransactionV1Envelope.signatures[i]);
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        TransactionV1Envelope.encode(stream, this);
    }

    public static TransactionV1Envelope decode(XdrDataInputStream stream) throws IOException {
        TransactionV1Envelope decodedTransactionV1Envelope = new TransactionV1Envelope();
        decodedTransactionV1Envelope.tx = Transaction.decode(stream);
        int signaturessize = stream.readInt();
        decodedTransactionV1Envelope.signatures = new DecoratedSignature[signaturessize];
        for (int i = 0; i < signaturessize; ++i) {
            decodedTransactionV1Envelope.signatures[i] = DecoratedSignature.decode(stream);
        }
        return decodedTransactionV1Envelope;
    }

    public int hashCode() {
        return Objects.hash(this.tx, Arrays.hashCode(this.signatures));
    }

    public boolean equals(Object object) {
        if (!(object instanceof TransactionV1Envelope)) {
            return false;
        }
        TransactionV1Envelope other = (TransactionV1Envelope)object;
        return Objects.equals(this.tx, other.tx) && Arrays.equals(this.signatures, other.signatures);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static TransactionV1Envelope fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TransactionV1Envelope.fromXdrByteArray(bytes);
    }

    public static TransactionV1Envelope fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TransactionV1Envelope.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private Transaction tx;
        private DecoratedSignature[] signatures;

        public Builder tx(Transaction tx) {
            this.tx = tx;
            return this;
        }

        public Builder signatures(DecoratedSignature[] signatures) {
            this.signatures = signatures;
            return this;
        }

        public TransactionV1Envelope build() {
            TransactionV1Envelope val = new TransactionV1Envelope();
            val.setTx(this.tx);
            val.setSignatures(this.signatures);
            return val;
        }
    }
}

