/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import org.stellar.sdk.xdr.XdrUnsignedInteger;

public class Uint32
implements XdrElement {
    private XdrUnsignedInteger uint32;

    public Uint32() {
    }

    public Uint32(XdrUnsignedInteger uint32) {
        this.uint32 = uint32;
    }

    public XdrUnsignedInteger getUint32() {
        return this.uint32;
    }

    public void setUint32(XdrUnsignedInteger value) {
        this.uint32 = value;
    }

    public static void encode(XdrDataOutputStream stream, Uint32 encodedUint32) throws IOException {
        encodedUint32.uint32.encode(stream);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        Uint32.encode(stream, this);
    }

    public static Uint32 decode(XdrDataInputStream stream) throws IOException {
        Uint32 decodedUint32 = new Uint32();
        decodedUint32.uint32 = XdrUnsignedInteger.decode(stream);
        return decodedUint32;
    }

    public int hashCode() {
        return Objects.hash(this.uint32);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Uint32)) {
            return false;
        }
        Uint32 other = (Uint32)object;
        return Objects.equals(this.uint32, other.uint32);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static Uint32 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return Uint32.fromXdrByteArray(bytes);
    }

    public static Uint32 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return Uint32.decode(xdrDataInputStream);
    }
}

