/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.LedgerEntryChanges;
import org.stellar.sdk.xdr.LedgerUpgrade;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class UpgradeEntryMeta
implements XdrElement {
    private LedgerUpgrade upgrade;
    private LedgerEntryChanges changes;

    public LedgerUpgrade getUpgrade() {
        return this.upgrade;
    }

    public void setUpgrade(LedgerUpgrade value) {
        this.upgrade = value;
    }

    public LedgerEntryChanges getChanges() {
        return this.changes;
    }

    public void setChanges(LedgerEntryChanges value) {
        this.changes = value;
    }

    public static void encode(XdrDataOutputStream stream, UpgradeEntryMeta encodedUpgradeEntryMeta) throws IOException {
        LedgerUpgrade.encode(stream, encodedUpgradeEntryMeta.upgrade);
        LedgerEntryChanges.encode(stream, encodedUpgradeEntryMeta.changes);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        UpgradeEntryMeta.encode(stream, this);
    }

    public static UpgradeEntryMeta decode(XdrDataInputStream stream) throws IOException {
        UpgradeEntryMeta decodedUpgradeEntryMeta = new UpgradeEntryMeta();
        decodedUpgradeEntryMeta.upgrade = LedgerUpgrade.decode(stream);
        decodedUpgradeEntryMeta.changes = LedgerEntryChanges.decode(stream);
        return decodedUpgradeEntryMeta;
    }

    public int hashCode() {
        return Objects.hash(this.upgrade, this.changes);
    }

    public boolean equals(Object object) {
        if (!(object instanceof UpgradeEntryMeta)) {
            return false;
        }
        UpgradeEntryMeta other = (UpgradeEntryMeta)object;
        return Objects.equals(this.upgrade, other.upgrade) && Objects.equals(this.changes, other.changes);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static UpgradeEntryMeta fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return UpgradeEntryMeta.fromXdrByteArray(bytes);
    }

    public static UpgradeEntryMeta fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return UpgradeEntryMeta.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private LedgerUpgrade upgrade;
        private LedgerEntryChanges changes;

        public Builder upgrade(LedgerUpgrade upgrade) {
            this.upgrade = upgrade;
            return this;
        }

        public Builder changes(LedgerEntryChanges changes) {
            this.changes = changes;
            return this;
        }

        public UpgradeEntryMeta build() {
            UpgradeEntryMeta val = new UpgradeEntryMeta();
            val.setUpgrade(this.upgrade);
            val.setChanges(this.changes);
            return val;
        }
    }
}

