// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * AccountEntryExtensionV1's original definition in the XDR file is:
 *
 * <pre>
 * struct AccountEntryExtensionV1
 * {
 *     Liabilities liabilities;
 *
 *     union switch (int v)
 *     {
 *     case 0:
 *         void;
 *     case 2:
 *         AccountEntryExtensionV2 v2;
 *     }
 *     ext;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class AccountEntryExtensionV1 implements XdrElement {
  private Liabilities liabilities;
  private AccountEntryExtensionV1Ext ext;

  public void encode(XdrDataOutputStream stream) throws IOException {
    liabilities.encode(stream);
    ext.encode(stream);
  }

  public static AccountEntryExtensionV1 decode(XdrDataInputStream stream) throws IOException {
    AccountEntryExtensionV1 decodedAccountEntryExtensionV1 = new AccountEntryExtensionV1();
    decodedAccountEntryExtensionV1.liabilities = Liabilities.decode(stream);
    decodedAccountEntryExtensionV1.ext = AccountEntryExtensionV1Ext.decode(stream);
    return decodedAccountEntryExtensionV1;
  }

  public static AccountEntryExtensionV1 fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static AccountEntryExtensionV1 fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * AccountEntryExtensionV1Ext's original definition in the XDR file is:
   *
   * <pre>
   * union switch (int v)
   *     {
   *     case 0:
   *         void;
   *     case 2:
   *         AccountEntryExtensionV2 v2;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class AccountEntryExtensionV1Ext implements XdrElement {
    private Integer discriminant;
    private AccountEntryExtensionV2 v2;

    public void encode(XdrDataOutputStream stream) throws IOException {
      stream.writeInt(discriminant);
      switch (discriminant) {
        case 0:
          break;
        case 2:
          v2.encode(stream);
          break;
      }
    }

    public static AccountEntryExtensionV1Ext decode(XdrDataInputStream stream) throws IOException {
      AccountEntryExtensionV1Ext decodedAccountEntryExtensionV1Ext =
          new AccountEntryExtensionV1Ext();
      Integer discriminant = stream.readInt();
      decodedAccountEntryExtensionV1Ext.setDiscriminant(discriminant);
      switch (decodedAccountEntryExtensionV1Ext.getDiscriminant()) {
        case 0:
          break;
        case 2:
          decodedAccountEntryExtensionV1Ext.v2 = AccountEntryExtensionV2.decode(stream);
          break;
      }
      return decodedAccountEntryExtensionV1Ext;
    }

    public static AccountEntryExtensionV1Ext fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static AccountEntryExtensionV1Ext fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
