// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * AccountMergeResult's original definition in the XDR file is:
 *
 * <pre>
 * union AccountMergeResult switch (AccountMergeResultCode code)
 * {
 * case ACCOUNT_MERGE_SUCCESS:
 *     int64 sourceAccountBalance; // how much got transferred from source account
 * case ACCOUNT_MERGE_MALFORMED:
 * case ACCOUNT_MERGE_NO_ACCOUNT:
 * case ACCOUNT_MERGE_IMMUTABLE_SET:
 * case ACCOUNT_MERGE_HAS_SUB_ENTRIES:
 * case ACCOUNT_MERGE_SEQNUM_TOO_FAR:
 * case ACCOUNT_MERGE_DEST_FULL:
 * case ACCOUNT_MERGE_IS_SPONSOR:
 *     void;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class AccountMergeResult implements XdrElement {
  private AccountMergeResultCode discriminant;
  private Int64 sourceAccountBalance;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case ACCOUNT_MERGE_SUCCESS:
        sourceAccountBalance.encode(stream);
        break;
      case ACCOUNT_MERGE_MALFORMED:
      case ACCOUNT_MERGE_NO_ACCOUNT:
      case ACCOUNT_MERGE_IMMUTABLE_SET:
      case ACCOUNT_MERGE_HAS_SUB_ENTRIES:
      case ACCOUNT_MERGE_SEQNUM_TOO_FAR:
      case ACCOUNT_MERGE_DEST_FULL:
      case ACCOUNT_MERGE_IS_SPONSOR:
        break;
    }
  }

  public static AccountMergeResult decode(XdrDataInputStream stream) throws IOException {
    AccountMergeResult decodedAccountMergeResult = new AccountMergeResult();
    AccountMergeResultCode discriminant = AccountMergeResultCode.decode(stream);
    decodedAccountMergeResult.setDiscriminant(discriminant);
    switch (decodedAccountMergeResult.getDiscriminant()) {
      case ACCOUNT_MERGE_SUCCESS:
        decodedAccountMergeResult.sourceAccountBalance = Int64.decode(stream);
        break;
      case ACCOUNT_MERGE_MALFORMED:
      case ACCOUNT_MERGE_NO_ACCOUNT:
      case ACCOUNT_MERGE_IMMUTABLE_SET:
      case ACCOUNT_MERGE_HAS_SUB_ENTRIES:
      case ACCOUNT_MERGE_SEQNUM_TOO_FAR:
      case ACCOUNT_MERGE_DEST_FULL:
      case ACCOUNT_MERGE_IS_SPONSOR:
        break;
    }
    return decodedAccountMergeResult;
  }

  public static AccountMergeResult fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static AccountMergeResult fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
