// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * Claimant's original definition in the XDR file is:
 *
 * <pre>
 * union Claimant switch (ClaimantType type)
 * {
 * case CLAIMANT_TYPE_V0:
 *     struct
 *     {
 *         AccountID destination;    // The account that can use this condition
 *         ClaimPredicate predicate; // Claimable if predicate is true
 *     } v0;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class Claimant implements XdrElement {
  private ClaimantType discriminant;
  private ClaimantV0 v0;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case CLAIMANT_TYPE_V0:
        v0.encode(stream);
        break;
    }
  }

  public static Claimant decode(XdrDataInputStream stream) throws IOException {
    Claimant decodedClaimant = new Claimant();
    ClaimantType discriminant = ClaimantType.decode(stream);
    decodedClaimant.setDiscriminant(discriminant);
    switch (decodedClaimant.getDiscriminant()) {
      case CLAIMANT_TYPE_V0:
        decodedClaimant.v0 = ClaimantV0.decode(stream);
        break;
    }
    return decodedClaimant;
  }

  public static Claimant fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static Claimant fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * ClaimantV0's original definition in the XDR file is:
   *
   * <pre>
   * struct
   *     {
   *         AccountID destination;    // The account that can use this condition
   *         ClaimPredicate predicate; // Claimable if predicate is true
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class ClaimantV0 implements XdrElement {
    private AccountID destination;
    private ClaimPredicate predicate;

    public void encode(XdrDataOutputStream stream) throws IOException {
      destination.encode(stream);
      predicate.encode(stream);
    }

    public static ClaimantV0 decode(XdrDataInputStream stream) throws IOException {
      ClaimantV0 decodedClaimantV0 = new ClaimantV0();
      decodedClaimantV0.destination = AccountID.decode(stream);
      decodedClaimantV0.predicate = ClaimPredicate.decode(stream);
      return decodedClaimantV0;
    }

    public static ClaimantV0 fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static ClaimantV0 fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
