// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * GeneralizedTransactionSet's original definition in the XDR file is:
 *
 * <pre>
 * union GeneralizedTransactionSet switch (int v)
 * {
 * // We consider the legacy TransactionSet to be v0.
 * case 1:
 *     TransactionSetV1 v1TxSet;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class GeneralizedTransactionSet implements XdrElement {
  private Integer discriminant;
  private TransactionSetV1 v1TxSet;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant);
    switch (discriminant) {
      case 1:
        v1TxSet.encode(stream);
        break;
    }
  }

  public static GeneralizedTransactionSet decode(XdrDataInputStream stream) throws IOException {
    GeneralizedTransactionSet decodedGeneralizedTransactionSet = new GeneralizedTransactionSet();
    Integer discriminant = stream.readInt();
    decodedGeneralizedTransactionSet.setDiscriminant(discriminant);
    switch (decodedGeneralizedTransactionSet.getDiscriminant()) {
      case 1:
        decodedGeneralizedTransactionSet.v1TxSet = TransactionSetV1.decode(stream);
        break;
    }
    return decodedGeneralizedTransactionSet;
  }

  public static GeneralizedTransactionSet fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static GeneralizedTransactionSet fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
