// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * LedgerEntryChange's original definition in the XDR file is:
 *
 * <pre>
 * union LedgerEntryChange switch (LedgerEntryChangeType type)
 * {
 * case LEDGER_ENTRY_CREATED:
 *     LedgerEntry created;
 * case LEDGER_ENTRY_UPDATED:
 *     LedgerEntry updated;
 * case LEDGER_ENTRY_REMOVED:
 *     LedgerKey removed;
 * case LEDGER_ENTRY_STATE:
 *     LedgerEntry state;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class LedgerEntryChange implements XdrElement {
  private LedgerEntryChangeType discriminant;
  private LedgerEntry created;
  private LedgerEntry updated;
  private LedgerKey removed;
  private LedgerEntry state;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case LEDGER_ENTRY_CREATED:
        created.encode(stream);
        break;
      case LEDGER_ENTRY_UPDATED:
        updated.encode(stream);
        break;
      case LEDGER_ENTRY_REMOVED:
        removed.encode(stream);
        break;
      case LEDGER_ENTRY_STATE:
        state.encode(stream);
        break;
    }
  }

  public static LedgerEntryChange decode(XdrDataInputStream stream) throws IOException {
    LedgerEntryChange decodedLedgerEntryChange = new LedgerEntryChange();
    LedgerEntryChangeType discriminant = LedgerEntryChangeType.decode(stream);
    decodedLedgerEntryChange.setDiscriminant(discriminant);
    switch (decodedLedgerEntryChange.getDiscriminant()) {
      case LEDGER_ENTRY_CREATED:
        decodedLedgerEntryChange.created = LedgerEntry.decode(stream);
        break;
      case LEDGER_ENTRY_UPDATED:
        decodedLedgerEntryChange.updated = LedgerEntry.decode(stream);
        break;
      case LEDGER_ENTRY_REMOVED:
        decodedLedgerEntryChange.removed = LedgerKey.decode(stream);
        break;
      case LEDGER_ENTRY_STATE:
        decodedLedgerEntryChange.state = LedgerEntry.decode(stream);
        break;
    }
    return decodedLedgerEntryChange;
  }

  public static LedgerEntryChange fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static LedgerEntryChange fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
