// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * LedgerHeader's original definition in the XDR file is:
 *
 * <pre>
 * struct LedgerHeader
 * {
 *     uint32 ledgerVersion;    // the protocol version of the ledger
 *     Hash previousLedgerHash; // hash of the previous ledger header
 *     StellarValue scpValue;   // what consensus agreed to
 *     Hash txSetResultHash;    // the TransactionResultSet that led to this ledger
 *     Hash bucketListHash;     // hash of the ledger state
 *
 *     uint32 ledgerSeq; // sequence number of this ledger
 *
 *     int64 totalCoins; // total number of stroops in existence.
 *                       // 10,000,000 stroops in 1 XLM
 *
 *     int64 feePool;       // fees burned since last inflation run
 *     uint32 inflationSeq; // inflation sequence number
 *
 *     uint64 idPool; // last used global ID, used for generating objects
 *
 *     uint32 baseFee;     // base fee per operation in stroops
 *     uint32 baseReserve; // account base reserve in stroops
 *
 *     uint32 maxTxSetSize; // maximum size a transaction set can be
 *
 *     Hash skipList[4]; // hashes of ledgers in the past. allows you to jump back
 *                       // in time without walking the chain back ledger by ledger
 *                       // each slot contains the oldest ledger that is mod of
 *                       // either 50  5000  50000 or 500000 depending on index
 *                       // skipList[0] mod(50), skipList[1] mod(5000), etc
 *
 *     // reserved for future use
 *     union switch (int v)
 *     {
 *     case 0:
 *         void;
 *     case 1:
 *         LedgerHeaderExtensionV1 v1;
 *     }
 *     ext;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class LedgerHeader implements XdrElement {
  private Uint32 ledgerVersion;
  private Hash previousLedgerHash;
  private StellarValue scpValue;
  private Hash txSetResultHash;
  private Hash bucketListHash;
  private Uint32 ledgerSeq;
  private Int64 totalCoins;
  private Int64 feePool;
  private Uint32 inflationSeq;
  private Uint64 idPool;
  private Uint32 baseFee;
  private Uint32 baseReserve;
  private Uint32 maxTxSetSize;
  private Hash[] skipList;
  private LedgerHeaderExt ext;

  public void encode(XdrDataOutputStream stream) throws IOException {
    ledgerVersion.encode(stream);
    previousLedgerHash.encode(stream);
    scpValue.encode(stream);
    txSetResultHash.encode(stream);
    bucketListHash.encode(stream);
    ledgerSeq.encode(stream);
    totalCoins.encode(stream);
    feePool.encode(stream);
    inflationSeq.encode(stream);
    idPool.encode(stream);
    baseFee.encode(stream);
    baseReserve.encode(stream);
    maxTxSetSize.encode(stream);
    int skipListSize = getSkipList().length;
    for (int i = 0; i < skipListSize; i++) {
      skipList[i].encode(stream);
    }
    ext.encode(stream);
  }

  public static LedgerHeader decode(XdrDataInputStream stream) throws IOException {
    LedgerHeader decodedLedgerHeader = new LedgerHeader();
    decodedLedgerHeader.ledgerVersion = Uint32.decode(stream);
    decodedLedgerHeader.previousLedgerHash = Hash.decode(stream);
    decodedLedgerHeader.scpValue = StellarValue.decode(stream);
    decodedLedgerHeader.txSetResultHash = Hash.decode(stream);
    decodedLedgerHeader.bucketListHash = Hash.decode(stream);
    decodedLedgerHeader.ledgerSeq = Uint32.decode(stream);
    decodedLedgerHeader.totalCoins = Int64.decode(stream);
    decodedLedgerHeader.feePool = Int64.decode(stream);
    decodedLedgerHeader.inflationSeq = Uint32.decode(stream);
    decodedLedgerHeader.idPool = Uint64.decode(stream);
    decodedLedgerHeader.baseFee = Uint32.decode(stream);
    decodedLedgerHeader.baseReserve = Uint32.decode(stream);
    decodedLedgerHeader.maxTxSetSize = Uint32.decode(stream);
    int skipListSize = 4;
    decodedLedgerHeader.skipList = new Hash[skipListSize];
    for (int i = 0; i < skipListSize; i++) {
      decodedLedgerHeader.skipList[i] = Hash.decode(stream);
    }
    decodedLedgerHeader.ext = LedgerHeaderExt.decode(stream);
    return decodedLedgerHeader;
  }

  public static LedgerHeader fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static LedgerHeader fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * LedgerHeaderExt's original definition in the XDR file is:
   *
   * <pre>
   * union switch (int v)
   *     {
   *     case 0:
   *         void;
   *     case 1:
   *         LedgerHeaderExtensionV1 v1;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class LedgerHeaderExt implements XdrElement {
    private Integer discriminant;
    private LedgerHeaderExtensionV1 v1;

    public void encode(XdrDataOutputStream stream) throws IOException {
      stream.writeInt(discriminant);
      switch (discriminant) {
        case 0:
          break;
        case 1:
          v1.encode(stream);
          break;
      }
    }

    public static LedgerHeaderExt decode(XdrDataInputStream stream) throws IOException {
      LedgerHeaderExt decodedLedgerHeaderExt = new LedgerHeaderExt();
      Integer discriminant = stream.readInt();
      decodedLedgerHeaderExt.setDiscriminant(discriminant);
      switch (decodedLedgerHeaderExt.getDiscriminant()) {
        case 0:
          break;
        case 1:
          decodedLedgerHeaderExt.v1 = LedgerHeaderExtensionV1.decode(stream);
          break;
      }
      return decodedLedgerHeaderExt;
    }

    public static LedgerHeaderExt fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static LedgerHeaderExt fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
