// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SCAddress's original definition in the XDR file is:
 *
 * <pre>
 * union SCAddress switch (SCAddressType type)
 * {
 * case SC_ADDRESS_TYPE_ACCOUNT:
 *     AccountID accountId;
 * case SC_ADDRESS_TYPE_CONTRACT:
 *     Hash contractId;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SCAddress implements XdrElement {
  private SCAddressType discriminant;
  private AccountID accountId;
  private Hash contractId;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case SC_ADDRESS_TYPE_ACCOUNT:
        accountId.encode(stream);
        break;
      case SC_ADDRESS_TYPE_CONTRACT:
        contractId.encode(stream);
        break;
    }
  }

  public static SCAddress decode(XdrDataInputStream stream) throws IOException {
    SCAddress decodedSCAddress = new SCAddress();
    SCAddressType discriminant = SCAddressType.decode(stream);
    decodedSCAddress.setDiscriminant(discriminant);
    switch (decodedSCAddress.getDiscriminant()) {
      case SC_ADDRESS_TYPE_ACCOUNT:
        decodedSCAddress.accountId = AccountID.decode(stream);
        break;
      case SC_ADDRESS_TYPE_CONTRACT:
        decodedSCAddress.contractId = Hash.decode(stream);
        break;
    }
    return decodedSCAddress;
  }

  public static SCAddress fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SCAddress fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
