// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SCEnvMetaEntry's original definition in the XDR file is:
 *
 * <pre>
 * union SCEnvMetaEntry switch (SCEnvMetaKind kind)
 * {
 * case SC_ENV_META_KIND_INTERFACE_VERSION:
 *     uint64 interfaceVersion;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SCEnvMetaEntry implements XdrElement {
  private SCEnvMetaKind discriminant;
  private Uint64 interfaceVersion;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case SC_ENV_META_KIND_INTERFACE_VERSION:
        interfaceVersion.encode(stream);
        break;
    }
  }

  public static SCEnvMetaEntry decode(XdrDataInputStream stream) throws IOException {
    SCEnvMetaEntry decodedSCEnvMetaEntry = new SCEnvMetaEntry();
    SCEnvMetaKind discriminant = SCEnvMetaKind.decode(stream);
    decodedSCEnvMetaEntry.setDiscriminant(discriminant);
    switch (decodedSCEnvMetaEntry.getDiscriminant()) {
      case SC_ENV_META_KIND_INTERFACE_VERSION:
        decodedSCEnvMetaEntry.interfaceVersion = Uint64.decode(stream);
        break;
    }
    return decodedSCEnvMetaEntry;
  }

  public static SCEnvMetaEntry fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SCEnvMetaEntry fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
