// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SCPStatement's original definition in the XDR file is:
 *
 * <pre>
 * struct SCPStatement
 * {
 *     NodeID nodeID;    // v
 *     uint64 slotIndex; // i
 *
 *     union switch (SCPStatementType type)
 *     {
 *     case SCP_ST_PREPARE:
 *         struct
 *         {
 *             Hash quorumSetHash;       // D
 *             SCPBallot ballot;         // b
 *             SCPBallot&#42; prepared;      // p
 *             SCPBallot&#42; preparedPrime; // p'
 *             uint32 nC;                // c.n
 *             uint32 nH;                // h.n
 *         } prepare;
 *     case SCP_ST_CONFIRM:
 *         struct
 *         {
 *             SCPBallot ballot;   // b
 *             uint32 nPrepared;   // p.n
 *             uint32 nCommit;     // c.n
 *             uint32 nH;          // h.n
 *             Hash quorumSetHash; // D
 *         } confirm;
 *     case SCP_ST_EXTERNALIZE:
 *         struct
 *         {
 *             SCPBallot commit;         // c
 *             uint32 nH;                // h.n
 *             Hash commitQuorumSetHash; // D used before EXTERNALIZE
 *         } externalize;
 *     case SCP_ST_NOMINATE:
 *         SCPNomination nominate;
 *     }
 *     pledges;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SCPStatement implements XdrElement {
  private NodeID nodeID;
  private Uint64 slotIndex;
  private SCPStatementPledges pledges;

  public void encode(XdrDataOutputStream stream) throws IOException {
    nodeID.encode(stream);
    slotIndex.encode(stream);
    pledges.encode(stream);
  }

  public static SCPStatement decode(XdrDataInputStream stream) throws IOException {
    SCPStatement decodedSCPStatement = new SCPStatement();
    decodedSCPStatement.nodeID = NodeID.decode(stream);
    decodedSCPStatement.slotIndex = Uint64.decode(stream);
    decodedSCPStatement.pledges = SCPStatementPledges.decode(stream);
    return decodedSCPStatement;
  }

  public static SCPStatement fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SCPStatement fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * SCPStatementPledges's original definition in the XDR file is:
   *
   * <pre>
   * union switch (SCPStatementType type)
   *     {
   *     case SCP_ST_PREPARE:
   *         struct
   *         {
   *             Hash quorumSetHash;       // D
   *             SCPBallot ballot;         // b
   *             SCPBallot&#42; prepared;      // p
   *             SCPBallot&#42; preparedPrime; // p'
   *             uint32 nC;                // c.n
   *             uint32 nH;                // h.n
   *         } prepare;
   *     case SCP_ST_CONFIRM:
   *         struct
   *         {
   *             SCPBallot ballot;   // b
   *             uint32 nPrepared;   // p.n
   *             uint32 nCommit;     // c.n
   *             uint32 nH;          // h.n
   *             Hash quorumSetHash; // D
   *         } confirm;
   *     case SCP_ST_EXTERNALIZE:
   *         struct
   *         {
   *             SCPBallot commit;         // c
   *             uint32 nH;                // h.n
   *             Hash commitQuorumSetHash; // D used before EXTERNALIZE
   *         } externalize;
   *     case SCP_ST_NOMINATE:
   *         SCPNomination nominate;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class SCPStatementPledges implements XdrElement {
    private SCPStatementType discriminant;
    private SCPStatementPrepare prepare;
    private SCPStatementConfirm confirm;
    private SCPStatementExternalize externalize;
    private SCPNomination nominate;

    public void encode(XdrDataOutputStream stream) throws IOException {
      stream.writeInt(discriminant.getValue());
      switch (discriminant) {
        case SCP_ST_PREPARE:
          prepare.encode(stream);
          break;
        case SCP_ST_CONFIRM:
          confirm.encode(stream);
          break;
        case SCP_ST_EXTERNALIZE:
          externalize.encode(stream);
          break;
        case SCP_ST_NOMINATE:
          nominate.encode(stream);
          break;
      }
    }

    public static SCPStatementPledges decode(XdrDataInputStream stream) throws IOException {
      SCPStatementPledges decodedSCPStatementPledges = new SCPStatementPledges();
      SCPStatementType discriminant = SCPStatementType.decode(stream);
      decodedSCPStatementPledges.setDiscriminant(discriminant);
      switch (decodedSCPStatementPledges.getDiscriminant()) {
        case SCP_ST_PREPARE:
          decodedSCPStatementPledges.prepare = SCPStatementPrepare.decode(stream);
          break;
        case SCP_ST_CONFIRM:
          decodedSCPStatementPledges.confirm = SCPStatementConfirm.decode(stream);
          break;
        case SCP_ST_EXTERNALIZE:
          decodedSCPStatementPledges.externalize = SCPStatementExternalize.decode(stream);
          break;
        case SCP_ST_NOMINATE:
          decodedSCPStatementPledges.nominate = SCPNomination.decode(stream);
          break;
      }
      return decodedSCPStatementPledges;
    }

    public static SCPStatementPledges fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static SCPStatementPledges fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }

    /**
     * SCPStatementPrepare's original definition in the XDR file is:
     *
     * <pre>
     * struct
     *         {
     *             Hash quorumSetHash;       // D
     *             SCPBallot ballot;         // b
     *             SCPBallot&#42; prepared;      // p
     *             SCPBallot&#42; preparedPrime; // p'
     *             uint32 nC;                // c.n
     *             uint32 nH;                // h.n
     *         }
     * </pre>
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder(toBuilder = true)
    public static class SCPStatementPrepare implements XdrElement {
      private Hash quorumSetHash;
      private SCPBallot ballot;
      private SCPBallot prepared;
      private SCPBallot preparedPrime;
      private Uint32 nC;
      private Uint32 nH;

      public void encode(XdrDataOutputStream stream) throws IOException {
        quorumSetHash.encode(stream);
        ballot.encode(stream);
        if (prepared != null) {
          stream.writeInt(1);
          prepared.encode(stream);
        } else {
          stream.writeInt(0);
        }
        if (preparedPrime != null) {
          stream.writeInt(1);
          preparedPrime.encode(stream);
        } else {
          stream.writeInt(0);
        }
        nC.encode(stream);
        nH.encode(stream);
      }

      public static SCPStatementPrepare decode(XdrDataInputStream stream) throws IOException {
        SCPStatementPrepare decodedSCPStatementPrepare = new SCPStatementPrepare();
        decodedSCPStatementPrepare.quorumSetHash = Hash.decode(stream);
        decodedSCPStatementPrepare.ballot = SCPBallot.decode(stream);
        int preparedPresent = stream.readInt();
        if (preparedPresent != 0) {
          decodedSCPStatementPrepare.prepared = SCPBallot.decode(stream);
        }
        int preparedPrimePresent = stream.readInt();
        if (preparedPrimePresent != 0) {
          decodedSCPStatementPrepare.preparedPrime = SCPBallot.decode(stream);
        }
        decodedSCPStatementPrepare.nC = Uint32.decode(stream);
        decodedSCPStatementPrepare.nH = Uint32.decode(stream);
        return decodedSCPStatementPrepare;
      }

      public static SCPStatementPrepare fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return fromXdrByteArray(bytes);
      }

      public static SCPStatementPrepare fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return decode(xdrDataInputStream);
      }
    }

    /**
     * SCPStatementConfirm's original definition in the XDR file is:
     *
     * <pre>
     * struct
     *         {
     *             SCPBallot ballot;   // b
     *             uint32 nPrepared;   // p.n
     *             uint32 nCommit;     // c.n
     *             uint32 nH;          // h.n
     *             Hash quorumSetHash; // D
     *         }
     * </pre>
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder(toBuilder = true)
    public static class SCPStatementConfirm implements XdrElement {
      private SCPBallot ballot;
      private Uint32 nPrepared;
      private Uint32 nCommit;
      private Uint32 nH;
      private Hash quorumSetHash;

      public void encode(XdrDataOutputStream stream) throws IOException {
        ballot.encode(stream);
        nPrepared.encode(stream);
        nCommit.encode(stream);
        nH.encode(stream);
        quorumSetHash.encode(stream);
      }

      public static SCPStatementConfirm decode(XdrDataInputStream stream) throws IOException {
        SCPStatementConfirm decodedSCPStatementConfirm = new SCPStatementConfirm();
        decodedSCPStatementConfirm.ballot = SCPBallot.decode(stream);
        decodedSCPStatementConfirm.nPrepared = Uint32.decode(stream);
        decodedSCPStatementConfirm.nCommit = Uint32.decode(stream);
        decodedSCPStatementConfirm.nH = Uint32.decode(stream);
        decodedSCPStatementConfirm.quorumSetHash = Hash.decode(stream);
        return decodedSCPStatementConfirm;
      }

      public static SCPStatementConfirm fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return fromXdrByteArray(bytes);
      }

      public static SCPStatementConfirm fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return decode(xdrDataInputStream);
      }
    }

    /**
     * SCPStatementExternalize's original definition in the XDR file is:
     *
     * <pre>
     * struct
     *         {
     *             SCPBallot commit;         // c
     *             uint32 nH;                // h.n
     *             Hash commitQuorumSetHash; // D used before EXTERNALIZE
     *         }
     * </pre>
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder(toBuilder = true)
    public static class SCPStatementExternalize implements XdrElement {
      private SCPBallot commit;
      private Uint32 nH;
      private Hash commitQuorumSetHash;

      public void encode(XdrDataOutputStream stream) throws IOException {
        commit.encode(stream);
        nH.encode(stream);
        commitQuorumSetHash.encode(stream);
      }

      public static SCPStatementExternalize decode(XdrDataInputStream stream) throws IOException {
        SCPStatementExternalize decodedSCPStatementExternalize = new SCPStatementExternalize();
        decodedSCPStatementExternalize.commit = SCPBallot.decode(stream);
        decodedSCPStatementExternalize.nH = Uint32.decode(stream);
        decodedSCPStatementExternalize.commitQuorumSetHash = Hash.decode(stream);
        return decodedSCPStatementExternalize;
      }

      public static SCPStatementExternalize fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return fromXdrByteArray(bytes);
      }

      public static SCPStatementExternalize fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return decode(xdrDataInputStream);
      }
    }
  }
}
