// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * StellarMessage's original definition in the XDR file is:
 *
 * <pre>
 * union StellarMessage switch (MessageType type)
 * {
 * case ERROR_MSG:
 *     Error error;
 * case HELLO:
 *     Hello hello;
 * case AUTH:
 *     Auth auth;
 * case DONT_HAVE:
 *     DontHave dontHave;
 * case GET_PEERS:
 *     void;
 * case PEERS:
 *     PeerAddress peers&lt;100&gt;;
 *
 * case GET_TX_SET:
 *     uint256 txSetHash;
 * case TX_SET:
 *     TransactionSet txSet;
 * case GENERALIZED_TX_SET:
 *     GeneralizedTransactionSet generalizedTxSet;
 *
 * case TRANSACTION:
 *     TransactionEnvelope transaction;
 *
 * case SURVEY_REQUEST:
 *     SignedSurveyRequestMessage signedSurveyRequestMessage;
 *
 * case SURVEY_RESPONSE:
 *     SignedSurveyResponseMessage signedSurveyResponseMessage;
 *
 * // SCP
 * case GET_SCP_QUORUMSET:
 *     uint256 qSetHash;
 * case SCP_QUORUMSET:
 *     SCPQuorumSet qSet;
 * case SCP_MESSAGE:
 *     SCPEnvelope envelope;
 * case GET_SCP_STATE:
 *     uint32 getSCPLedgerSeq; // ledger seq requested ; if 0, requests the latest
 * case SEND_MORE:
 *     SendMore sendMoreMessage;
 * case SEND_MORE_EXTENDED:
 *     SendMoreExtended sendMoreExtendedMessage;
 * // Pull mode
 * case FLOOD_ADVERT:
 *      FloodAdvert floodAdvert;
 * case FLOOD_DEMAND:
 *      FloodDemand floodDemand;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class StellarMessage implements XdrElement {
  private MessageType discriminant;
  private Error error;
  private Hello hello;
  private Auth auth;
  private DontHave dontHave;
  private PeerAddress[] peers;
  private Uint256 txSetHash;
  private TransactionSet txSet;
  private GeneralizedTransactionSet generalizedTxSet;
  private TransactionEnvelope transaction;
  private SignedSurveyRequestMessage signedSurveyRequestMessage;
  private SignedSurveyResponseMessage signedSurveyResponseMessage;
  private Uint256 qSetHash;
  private SCPQuorumSet qSet;
  private SCPEnvelope envelope;
  private Uint32 getSCPLedgerSeq;
  private SendMore sendMoreMessage;
  private SendMoreExtended sendMoreExtendedMessage;
  private FloodAdvert floodAdvert;
  private FloodDemand floodDemand;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case ERROR_MSG:
        error.encode(stream);
        break;
      case HELLO:
        hello.encode(stream);
        break;
      case AUTH:
        auth.encode(stream);
        break;
      case DONT_HAVE:
        dontHave.encode(stream);
        break;
      case GET_PEERS:
        break;
      case PEERS:
        int peersSize = getPeers().length;
        stream.writeInt(peersSize);
        for (int i = 0; i < peersSize; i++) {
          peers[i].encode(stream);
        }
        break;
      case GET_TX_SET:
        txSetHash.encode(stream);
        break;
      case TX_SET:
        txSet.encode(stream);
        break;
      case GENERALIZED_TX_SET:
        generalizedTxSet.encode(stream);
        break;
      case TRANSACTION:
        transaction.encode(stream);
        break;
      case SURVEY_REQUEST:
        signedSurveyRequestMessage.encode(stream);
        break;
      case SURVEY_RESPONSE:
        signedSurveyResponseMessage.encode(stream);
        break;
      case GET_SCP_QUORUMSET:
        qSetHash.encode(stream);
        break;
      case SCP_QUORUMSET:
        qSet.encode(stream);
        break;
      case SCP_MESSAGE:
        envelope.encode(stream);
        break;
      case GET_SCP_STATE:
        getSCPLedgerSeq.encode(stream);
        break;
      case SEND_MORE:
        sendMoreMessage.encode(stream);
        break;
      case SEND_MORE_EXTENDED:
        sendMoreExtendedMessage.encode(stream);
        break;
      case FLOOD_ADVERT:
        floodAdvert.encode(stream);
        break;
      case FLOOD_DEMAND:
        floodDemand.encode(stream);
        break;
    }
  }

  public static StellarMessage decode(XdrDataInputStream stream) throws IOException {
    StellarMessage decodedStellarMessage = new StellarMessage();
    MessageType discriminant = MessageType.decode(stream);
    decodedStellarMessage.setDiscriminant(discriminant);
    switch (decodedStellarMessage.getDiscriminant()) {
      case ERROR_MSG:
        decodedStellarMessage.error = Error.decode(stream);
        break;
      case HELLO:
        decodedStellarMessage.hello = Hello.decode(stream);
        break;
      case AUTH:
        decodedStellarMessage.auth = Auth.decode(stream);
        break;
      case DONT_HAVE:
        decodedStellarMessage.dontHave = DontHave.decode(stream);
        break;
      case GET_PEERS:
        break;
      case PEERS:
        int peersSize = stream.readInt();
        decodedStellarMessage.peers = new PeerAddress[peersSize];
        for (int i = 0; i < peersSize; i++) {
          decodedStellarMessage.peers[i] = PeerAddress.decode(stream);
        }
        break;
      case GET_TX_SET:
        decodedStellarMessage.txSetHash = Uint256.decode(stream);
        break;
      case TX_SET:
        decodedStellarMessage.txSet = TransactionSet.decode(stream);
        break;
      case GENERALIZED_TX_SET:
        decodedStellarMessage.generalizedTxSet = GeneralizedTransactionSet.decode(stream);
        break;
      case TRANSACTION:
        decodedStellarMessage.transaction = TransactionEnvelope.decode(stream);
        break;
      case SURVEY_REQUEST:
        decodedStellarMessage.signedSurveyRequestMessage =
            SignedSurveyRequestMessage.decode(stream);
        break;
      case SURVEY_RESPONSE:
        decodedStellarMessage.signedSurveyResponseMessage =
            SignedSurveyResponseMessage.decode(stream);
        break;
      case GET_SCP_QUORUMSET:
        decodedStellarMessage.qSetHash = Uint256.decode(stream);
        break;
      case SCP_QUORUMSET:
        decodedStellarMessage.qSet = SCPQuorumSet.decode(stream);
        break;
      case SCP_MESSAGE:
        decodedStellarMessage.envelope = SCPEnvelope.decode(stream);
        break;
      case GET_SCP_STATE:
        decodedStellarMessage.getSCPLedgerSeq = Uint32.decode(stream);
        break;
      case SEND_MORE:
        decodedStellarMessage.sendMoreMessage = SendMore.decode(stream);
        break;
      case SEND_MORE_EXTENDED:
        decodedStellarMessage.sendMoreExtendedMessage = SendMoreExtended.decode(stream);
        break;
      case FLOOD_ADVERT:
        decodedStellarMessage.floodAdvert = FloodAdvert.decode(stream);
        break;
      case FLOOD_DEMAND:
        decodedStellarMessage.floodDemand = FloodDemand.decode(stream);
        break;
    }
    return decodedStellarMessage;
  }

  public static StellarMessage fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static StellarMessage fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
