// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * TransactionResult's original definition in the XDR file is:
 *
 * <pre>
 * struct TransactionResult
 * {
 *     int64 feeCharged; // actual fee charged for the transaction
 *
 *     union switch (TransactionResultCode code)
 *     {
 *     case txFEE_BUMP_INNER_SUCCESS:
 *     case txFEE_BUMP_INNER_FAILED:
 *         InnerTransactionResultPair innerResultPair;
 *     case txSUCCESS:
 *     case txFAILED:
 *         OperationResult results&lt;&gt;;
 *     case txTOO_EARLY:
 *     case txTOO_LATE:
 *     case txMISSING_OPERATION:
 *     case txBAD_SEQ:
 *     case txBAD_AUTH:
 *     case txINSUFFICIENT_BALANCE:
 *     case txNO_ACCOUNT:
 *     case txINSUFFICIENT_FEE:
 *     case txBAD_AUTH_EXTRA:
 *     case txINTERNAL_ERROR:
 *     case txNOT_SUPPORTED:
 *     // case txFEE_BUMP_INNER_FAILED: handled above
 *     case txBAD_SPONSORSHIP:
 *     case txBAD_MIN_SEQ_AGE_OR_GAP:
 *     case txMALFORMED:
 *     case txSOROBAN_INVALID:
 *         void;
 *     }
 *     result;
 *
 *     // reserved for future use
 *     union switch (int v)
 *     {
 *     case 0:
 *         void;
 *     }
 *     ext;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class TransactionResult implements XdrElement {
  private Int64 feeCharged;
  private TransactionResultResult result;
  private TransactionResultExt ext;

  public void encode(XdrDataOutputStream stream) throws IOException {
    feeCharged.encode(stream);
    result.encode(stream);
    ext.encode(stream);
  }

  public static TransactionResult decode(XdrDataInputStream stream) throws IOException {
    TransactionResult decodedTransactionResult = new TransactionResult();
    decodedTransactionResult.feeCharged = Int64.decode(stream);
    decodedTransactionResult.result = TransactionResultResult.decode(stream);
    decodedTransactionResult.ext = TransactionResultExt.decode(stream);
    return decodedTransactionResult;
  }

  public static TransactionResult fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static TransactionResult fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * TransactionResultResult's original definition in the XDR file is:
   *
   * <pre>
   * union switch (TransactionResultCode code)
   *     {
   *     case txFEE_BUMP_INNER_SUCCESS:
   *     case txFEE_BUMP_INNER_FAILED:
   *         InnerTransactionResultPair innerResultPair;
   *     case txSUCCESS:
   *     case txFAILED:
   *         OperationResult results&lt;&gt;;
   *     case txTOO_EARLY:
   *     case txTOO_LATE:
   *     case txMISSING_OPERATION:
   *     case txBAD_SEQ:
   *     case txBAD_AUTH:
   *     case txINSUFFICIENT_BALANCE:
   *     case txNO_ACCOUNT:
   *     case txINSUFFICIENT_FEE:
   *     case txBAD_AUTH_EXTRA:
   *     case txINTERNAL_ERROR:
   *     case txNOT_SUPPORTED:
   *     // case txFEE_BUMP_INNER_FAILED: handled above
   *     case txBAD_SPONSORSHIP:
   *     case txBAD_MIN_SEQ_AGE_OR_GAP:
   *     case txMALFORMED:
   *     case txSOROBAN_INVALID:
   *         void;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class TransactionResultResult implements XdrElement {
    private TransactionResultCode discriminant;
    private InnerTransactionResultPair innerResultPair;
    private OperationResult[] results;

    public void encode(XdrDataOutputStream stream) throws IOException {
      stream.writeInt(discriminant.getValue());
      switch (discriminant) {
        case txFEE_BUMP_INNER_SUCCESS:
        case txFEE_BUMP_INNER_FAILED:
          innerResultPair.encode(stream);
          break;
        case txSUCCESS:
        case txFAILED:
          int resultsSize = getResults().length;
          stream.writeInt(resultsSize);
          for (int i = 0; i < resultsSize; i++) {
            results[i].encode(stream);
          }
          break;
        case txTOO_EARLY:
        case txTOO_LATE:
        case txMISSING_OPERATION:
        case txBAD_SEQ:
        case txBAD_AUTH:
        case txINSUFFICIENT_BALANCE:
        case txNO_ACCOUNT:
        case txINSUFFICIENT_FEE:
        case txBAD_AUTH_EXTRA:
        case txINTERNAL_ERROR:
        case txNOT_SUPPORTED:
        case txBAD_SPONSORSHIP:
        case txBAD_MIN_SEQ_AGE_OR_GAP:
        case txMALFORMED:
        case txSOROBAN_INVALID:
          break;
      }
    }

    public static TransactionResultResult decode(XdrDataInputStream stream) throws IOException {
      TransactionResultResult decodedTransactionResultResult = new TransactionResultResult();
      TransactionResultCode discriminant = TransactionResultCode.decode(stream);
      decodedTransactionResultResult.setDiscriminant(discriminant);
      switch (decodedTransactionResultResult.getDiscriminant()) {
        case txFEE_BUMP_INNER_SUCCESS:
        case txFEE_BUMP_INNER_FAILED:
          decodedTransactionResultResult.innerResultPair =
              InnerTransactionResultPair.decode(stream);
          break;
        case txSUCCESS:
        case txFAILED:
          int resultsSize = stream.readInt();
          decodedTransactionResultResult.results = new OperationResult[resultsSize];
          for (int i = 0; i < resultsSize; i++) {
            decodedTransactionResultResult.results[i] = OperationResult.decode(stream);
          }
          break;
        case txTOO_EARLY:
        case txTOO_LATE:
        case txMISSING_OPERATION:
        case txBAD_SEQ:
        case txBAD_AUTH:
        case txINSUFFICIENT_BALANCE:
        case txNO_ACCOUNT:
        case txINSUFFICIENT_FEE:
        case txBAD_AUTH_EXTRA:
        case txINTERNAL_ERROR:
        case txNOT_SUPPORTED:
        case txBAD_SPONSORSHIP:
        case txBAD_MIN_SEQ_AGE_OR_GAP:
        case txMALFORMED:
        case txSOROBAN_INVALID:
          break;
      }
      return decodedTransactionResultResult;
    }

    public static TransactionResultResult fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static TransactionResultResult fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }

  /**
   * TransactionResultExt's original definition in the XDR file is:
   *
   * <pre>
   * union switch (int v)
   *     {
   *     case 0:
   *         void;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class TransactionResultExt implements XdrElement {
    private Integer discriminant;

    public void encode(XdrDataOutputStream stream) throws IOException {
      stream.writeInt(discriminant);
      switch (discriminant) {
        case 0:
          break;
      }
    }

    public static TransactionResultExt decode(XdrDataInputStream stream) throws IOException {
      TransactionResultExt decodedTransactionResultExt = new TransactionResultExt();
      Integer discriminant = stream.readInt();
      decodedTransactionResultExt.setDiscriminant(discriminant);
      switch (decodedTransactionResultExt.getDiscriminant()) {
        case 0:
          break;
      }
      return decodedTransactionResultExt;
    }

    public static TransactionResultExt fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static TransactionResultExt fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
