// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * TransactionV0's original definition in the XDR file is:
 *
 * <pre>
 * struct TransactionV0
 * {
 *     uint256 sourceAccountEd25519;
 *     uint32 fee;
 *     SequenceNumber seqNum;
 *     TimeBounds&#42; timeBounds;
 *     Memo memo;
 *     Operation operations&lt;MAX_OPS_PER_TX&gt;;
 *     union switch (int v)
 *     {
 *     case 0:
 *         void;
 *     }
 *     ext;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class TransactionV0 implements XdrElement {
  private Uint256 sourceAccountEd25519;
  private Uint32 fee;
  private SequenceNumber seqNum;
  private TimeBounds timeBounds;
  private Memo memo;
  private Operation[] operations;
  private TransactionV0Ext ext;

  public void encode(XdrDataOutputStream stream) throws IOException {
    sourceAccountEd25519.encode(stream);
    fee.encode(stream);
    seqNum.encode(stream);
    if (timeBounds != null) {
      stream.writeInt(1);
      timeBounds.encode(stream);
    } else {
      stream.writeInt(0);
    }
    memo.encode(stream);
    int operationsSize = getOperations().length;
    stream.writeInt(operationsSize);
    for (int i = 0; i < operationsSize; i++) {
      operations[i].encode(stream);
    }
    ext.encode(stream);
  }

  public static TransactionV0 decode(XdrDataInputStream stream) throws IOException {
    TransactionV0 decodedTransactionV0 = new TransactionV0();
    decodedTransactionV0.sourceAccountEd25519 = Uint256.decode(stream);
    decodedTransactionV0.fee = Uint32.decode(stream);
    decodedTransactionV0.seqNum = SequenceNumber.decode(stream);
    int timeBoundsPresent = stream.readInt();
    if (timeBoundsPresent != 0) {
      decodedTransactionV0.timeBounds = TimeBounds.decode(stream);
    }
    decodedTransactionV0.memo = Memo.decode(stream);
    int operationsSize = stream.readInt();
    decodedTransactionV0.operations = new Operation[operationsSize];
    for (int i = 0; i < operationsSize; i++) {
      decodedTransactionV0.operations[i] = Operation.decode(stream);
    }
    decodedTransactionV0.ext = TransactionV0Ext.decode(stream);
    return decodedTransactionV0;
  }

  public static TransactionV0 fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static TransactionV0 fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * TransactionV0Ext's original definition in the XDR file is:
   *
   * <pre>
   * union switch (int v)
   *     {
   *     case 0:
   *         void;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class TransactionV0Ext implements XdrElement {
    private Integer discriminant;

    public void encode(XdrDataOutputStream stream) throws IOException {
      stream.writeInt(discriminant);
      switch (discriminant) {
        case 0:
          break;
      }
    }

    public static TransactionV0Ext decode(XdrDataInputStream stream) throws IOException {
      TransactionV0Ext decodedTransactionV0Ext = new TransactionV0Ext();
      Integer discriminant = stream.readInt();
      decodedTransactionV0Ext.setDiscriminant(discriminant);
      switch (decodedTransactionV0Ext.getDiscriminant()) {
        case 0:
          break;
      }
      return decodedTransactionV0Ext;
    }

    public static TransactionV0Ext fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static TransactionV0Ext fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
