/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import lombok.NonNull;
import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeCreditAlphaNum;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.Util;
import org.stellar.sdk.exception.AssetCodeLengthInvalidException;
import org.stellar.sdk.xdr.AlphaNum4;
import org.stellar.sdk.xdr.AssetCode4;
import org.stellar.sdk.xdr.AssetType;

public final class AssetTypeCreditAlphaNum4
extends AssetTypeCreditAlphaNum {
    public AssetTypeCreditAlphaNum4(String code, String issuer) {
        super(code, issuer);
        if (code.isEmpty() || code.length() > 4) {
            throw new AssetCodeLengthInvalidException();
        }
    }

    @Override
    public AssetType getType() {
        return AssetType.ASSET_TYPE_CREDIT_ALPHANUM4;
    }

    public static AssetTypeCreditAlphaNum4 fromXdr(AlphaNum4 alphaNum4) {
        String assetCode4 = Util.paddedByteArrayToString(alphaNum4.getAssetCode().getAssetCode4());
        String accountId = StrKey.encodeEd25519PublicKey(alphaNum4.getIssuer());
        return new AssetTypeCreditAlphaNum4(assetCode4, accountId);
    }

    @Override
    public org.stellar.sdk.xdr.Asset toXdr() {
        org.stellar.sdk.xdr.Asset xdr = new org.stellar.sdk.xdr.Asset();
        xdr.setDiscriminant(AssetType.ASSET_TYPE_CREDIT_ALPHANUM4);
        AlphaNum4 credit = new AlphaNum4();
        AssetCode4 assetCode4 = new AssetCode4();
        assetCode4.setAssetCode4(Util.paddedByteArray(this.code, 4));
        credit.setAssetCode(assetCode4);
        credit.setIssuer(StrKey.encodeToXDRAccountId(this.issuer));
        xdr.setAlphaNum4(credit);
        return xdr;
    }

    @Override
    public int compareTo(@NonNull Asset other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        if (AssetType.ASSET_TYPE_CREDIT_ALPHANUM12.equals(other.getType())) {
            return -1;
        }
        if (AssetType.ASSET_TYPE_NATIVE.equals(other.getType())) {
            return 1;
        }
        AssetTypeCreditAlphaNum o = (AssetTypeCreditAlphaNum)other;
        if (!this.getCode().equals(o.getCode())) {
            return this.getCode().compareTo(o.getCode());
        }
        return this.getIssuer().compareTo(o.getIssuer());
    }
}

